"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactHookForm = require("react-hook-form");
var _pack_shards_field = require("./shards/pack_shards_field");
var _kibana = require("../../common/lib/kibana");
var _policy_id_combobox_field = require("./policy_id_combobox_field");
var _queries_field = require("./queries_field");
var _confirmation_modal = require("./confirmation_modal");
var _agent_policies = require("../../agent_policies");
var _use_create_pack = require("../use_create_pack");
var _use_update_pack = require("../use_update_pack");
var _utils = require("./utils");
var _name_field = require("./name_field");
var _description_field = require("./description_field");
var _pack_type_selectable = require("./shards/pack_type_selectable");
var _utils2 = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/form/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const euiAccordionCss = ({
  euiTheme
}) => ({
  '.euiAccordion__button': {
    color: euiTheme.colors.primary
  }
});
const PackFormComponent = ({
  defaultValue,
  editMode = false,
  isReadOnly = false,
  packId
}) => {
  const [shardsToggleState, setShardsToggleState] = (0, _react.useState)('closed');
  const handleToggle = (0, _react.useCallback)(isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setShardsToggleState(newState);
  }, []);
  const [packType, setPackType] = (0, _react.useState)('policy');
  const [showConfirmationModal, setShowConfirmationModal] = (0, _react.useState)(false);
  const handleHideConfirmationModal = (0, _react.useCallback)(() => setShowConfirmationModal(false), []);
  const {
    data: {
      agentPoliciesById
    } = {}
  } = (0, _agent_policies.useAgentPolicies)();
  const cancelButtonProps = (0, _kibana.useRouterNavigate)(`packs/${editMode ? packId !== null && packId !== void 0 ? packId : defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.id : ''}`);
  const {
    mutateAsync: createAsync
  } = (0, _use_create_pack.useCreatePack)({
    withRedirect: true
  });
  const {
    mutateAsync: updateAsync
  } = (0, _use_update_pack.useUpdatePack)({
    withRedirect: true
  });
  const deserializer = payload => {
    var _omit;
    const defaultPolicyIds = (0, _lodash.filter)(payload.policy_ids, policyId => {
      var _payload$shards;
      return ((_payload$shards = payload.shards) === null || _payload$shards === void 0 ? void 0 : _payload$shards[policyId]) == null;
    });
    return {
      ...payload,
      policy_ids: defaultPolicyIds !== null && defaultPolicyIds !== void 0 ? defaultPolicyIds : [],
      queries: (0, _utils.convertPackQueriesToSO)(payload.queries),
      shards: (_omit = (0, _lodash.omit)(payload.shards, '*')) !== null && _omit !== void 0 ? _omit : {}
    };
  };
  const hooksForm = (0, _reactHookForm.useForm)({
    defaultValues: defaultValue ? deserializer(defaultValue) : {
      name: '',
      description: '',
      policy_ids: [],
      enabled: true,
      queries: []
    }
  });
  (0, _react.useEffect)(() => {
    if (!(0, _lodash.isEmpty)(defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.shards)) {
      var _defaultValue$shards;
      if (defaultValue !== null && defaultValue !== void 0 && (_defaultValue$shards = defaultValue.shards) !== null && _defaultValue$shards !== void 0 && _defaultValue$shards['*']) {
        setPackType('global');
      } else {
        setShardsToggleState('open');
      }
    }
  }, [defaultValue, defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.shards]);
  const {
    handleSubmit,
    watch,
    formState: {
      isSubmitting
    }
  } = hooksForm;
  const {
    policy_ids: policyIds,
    shards
  } = watch();
  const getShards = (0, _react.useCallback)(() => {
    if (packType === 'global') {
      return {
        '*': 100
      };
    }
    return (0, _lodash.reduce)(shards, (acc, shard, key) => {
      if (!(0, _lodash.isEmpty)(key)) {
        return {
          ...acc,
          [key]: shard
        };
      }
      return acc;
    }, {});
  }, [packType, shards]);
  const onSubmit = (0, _react.useCallback)(async values => {
    const serializer = ({
      shards: _,
      policy_ids: payloadAgentPolicyIds,
      queries,
      ...restPayload
    }) => {
      var _getShards;
      const mappedShards = !(0, _lodash.isEmpty)(shards) ? (0, _lodash.filter)((0, _lodash.map)(shards, (shard, key) => {
        if (!(0, _lodash.isEmpty)(key)) {
          return key;
        }
      })) : [];
      const policies = [...payloadAgentPolicyIds, ...mappedShards];
      return {
        ...restPayload,
        policy_ids: policies !== null && policies !== void 0 ? policies : [],
        queries: (0, _utils.convertSOQueriesToPack)(queries),
        shards: (_getShards = getShards()) !== null && _getShards !== void 0 ? _getShards : {}
      };
    };
    try {
      if (editMode && defaultValue !== null && defaultValue !== void 0 && defaultValue.saved_object_id) {
        await updateAsync({
          id: defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.saved_object_id,
          ...serializer(values)
        });
      } else {
        await createAsync(serializer(values));
      }
      // eslint-disable-next-line no-empty
    } catch (e) {}
  }, [createAsync, defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.saved_object_id, editMode, getShards, shards, updateAsync]);
  const handleSubmitForm = (0, _react.useMemo)(() => handleSubmit(onSubmit), [handleSubmit, onSubmit]);
  const agentCount = (0, _react.useMemo)(() => (0, _lodash.reduce)(policyIds, (acc, policyId) => {
    var _agentPolicy$agents;
    const agentPolicy = agentPoliciesById && agentPoliciesById[policyId];
    return acc + ((_agentPolicy$agents = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.agents) !== null && _agentPolicy$agents !== void 0 ? _agentPolicy$agents : 0);
  }, 0), [policyIds, agentPoliciesById]);
  const handleSaveClick = (0, _react.useCallback)(() => {
    if (agentCount) {
      setShowConfirmationModal(true);
      return;
    }
    handleSubmitForm();
  }, [agentCount, handleSubmitForm]);
  const handleConfirmConfirmationClick = (0, _react.useCallback)(() => {
    handleSubmitForm();
    setShowConfirmationModal(false);
  }, [handleSubmitForm]);
  const euiFieldProps = (0, _react.useMemo)(() => ({
    isDisabled: isReadOnly
  }), [isReadOnly]);
  const changePackType = (0, _react.useCallback)(type => {
    setPackType(type);
  }, [setPackType]);
  const options = (0, _react.useMemo)(() => Object.entries(agentPoliciesById !== null && agentPoliciesById !== void 0 ? agentPoliciesById : {}).map(([agentPolicyId, agentPolicy]) => ({
    key: agentPolicyId,
    label: agentPolicy.name
  })), [agentPoliciesById]);
  const availableOptions = (0, _react.useMemo)(() => {
    const currentShardsFieldValues = (0, _lodash.map)(shards, (shard, key) => key);
    const currentPolicyIdsFieldValues = (0, _lodash.map)(policyIds, policy => policy);
    const currentValues = [...currentShardsFieldValues, ...currentPolicyIdsFieldValues];
    return options.filter(({
      key
    }) => !currentValues.includes(key));
  }, [shards, policyIds, options]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, hooksForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_name_field.NameField, {
    euiFieldProps: euiFieldProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_description_field.DescriptionField, {
    euiFieldProps: euiFieldProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_pack_type_selectable.PackTypeSelectable, {
    packType: packType,
    setPackType: changePackType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  }), packType === 'policy' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils2.overflowCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_policy_id_combobox_field.PolicyIdComboBoxField, {
    options: availableOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils2.overflowCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    css: euiAccordionCss,
    id: "shardsToggle",
    forceState: shardsToggleState,
    onToggle: handleToggle,
    buttonContent: "Partial deployment (shards)",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_pack_shards_field.PackShardsField, {
    options: availableOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_queries_field.QueriesField, {
    euiFieldProps: euiFieldProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    color: "text"
  }, cancelButtonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isSubmitting,
    color: "primary",
    fill: true,
    size: "m",
    iconType: "save",
    onClick: handleSaveClick,
    "data-test-subj": `${editMode ? 'update' : 'save'}-pack-button`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 17
    }
  }, editMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.updatePackButtonLabel",
    defaultMessage: "Update pack",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.savePackButtonLabel",
    defaultMessage: "Save pack",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 21
    }
  }))))))), showConfirmationModal && /*#__PURE__*/_react.default.createElement(_confirmation_modal.ConfirmDeployAgentPolicyModal, {
    onCancel: handleHideConfirmationModal,
    onConfirm: handleConfirmConfirmationClick,
    agentCount: agentCount,
    agentPolicyCount: policyIds.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 9
    }
  }));
};
const PackForm = exports.PackForm = /*#__PURE__*/_react.default.memo(PackFormComponent, _fastDeepEqual.default);