"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DescriptionField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/form/description_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DescriptionFieldComponent = ({
  euiFieldProps
}) => {
  const {
    field: {
      onChange,
      value,
      name: fieldName
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'description',
    defaultValue: ''
  });
  const hasError = (0, _react.useMemo)(() => !!(error !== null && error !== void 0 && error.message), [error === null || error === void 0 ? void 0 : error.message]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.osquery.pack.form.descriptionFieldLabel', {
      defaultMessage: 'Description (optional)'
    }),
    error: error === null || error === void 0 ? void 0 : error.message,
    isInvalid: hasError,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    isInvalid: hasError,
    onChange: onChange,
    value: value,
    name: fieldName,
    fullWidth: true,
    "data-test-subj": "input"
  }, euiFieldProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  })));
};
const DescriptionField = exports.DescriptionField = /*#__PURE__*/_react.default.memo(DescriptionFieldComponent);