"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValidateAgentId = void 0;
var _react = require("react");
var _use_agents = require("./use_agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useValidateAgentId = () => {
  const {
    agents
  } = (0, _use_agents.useOnechatAgents)();
  const agentIds = (0, _react.useMemo)(() => new Set(agents.map(agent => agent.id)), [agents]);
  const validateAgentId = (0, _react.useCallback)(agentId => {
    if (!agentId) {
      return false;
    }
    return agentIds.has(agentId);
  }, [agentIds]);
  return validateAgentId;
};
exports.useValidateAgentId = useValidateAgentId;