"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatTools = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _onechatCommon = require("@kbn/onechat-common");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../common/doc_links");
var _tools_provider = require("../../context/tools_provider");
var _use_navigation = require("../../hooks/use_navigation");
var _app_paths = require("../../utils/app_paths");
var _i18n2 = require("../../utils/i18n");
var _tools_table = require("./table/tools_table");
var _mcp_connection_button = require("./mcp_server/mcp_connection_button");
var _tech_preview = require("../common/tech_preview");
var _use_ui_privileges = require("../../hooks/use_ui_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/tools.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OnechatTools = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    createTool
  } = (0, _tools_provider.useToolsActions)();
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    manageTools
  } = (0, _use_ui_privileges.useUiPrivileges)();
  return /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react2.default.createElement(_tech_preview.TechPreviewTitle, {
      title: _i18n2.labels.tools.title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 20
      }
    }),
    description: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.tools.toolsDescription",
      defaultMessage: "Tools are modular, reusable Elasticsearch operations. {agentsLink} use them to search, retrieve, and analyze your data. Use our built-in tools for common operations, and create your own for custom use cases. {learnMoreLink}",
      values: {
        agentsLink: /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
          href: createOnechatUrl(_app_paths.appPaths.agents.list),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 41,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.onechat.tools.agentsLinkText', {
          defaultMessage: 'Agents'
        })),
        learnMoreLink: /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.tools,
          target: "_blank",
          "aria-label": _i18n.i18n.translate('xpack.onechat.tools.toolsDocumentationAriaLabel', {
            defaultMessage: 'Learn more about tools in the documentation'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 48,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.onechat.tools.toolsDocumentation', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 11
      }
    }),
    css: (0, _react.css)`
          background-color: ${euiTheme.colors.backgroundBasePlain};
          border-block-end: none;
        `,
    rightSideItems: [manageTools && /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      key: "new-esql-tool-button",
      fill: true,
      iconType: "plus",
      onClick: () => createTool(_onechatCommon.ToolType.esql),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    }, _i18n2.labels.tools.newToolButton)), /*#__PURE__*/_react2.default.createElement(_mcp_connection_button.McpConnectionButton, {
      key: "mcp-server-connection-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_tools_table.OnechatToolsTable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  })));
};
exports.OnechatTools = OnechatTools;