"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tool = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../common/doc_links");
var _use_tool_form = require("../../hooks/tools/use_tool_form");
var _use_kibana = require("../../hooks/use_kibana");
var _use_navigation = require("../../hooks/use_navigation");
var _use_query_state = require("../../hooks/use_query_state");
var _app_paths = require("../../utils/app_paths");
var _i18n2 = require("../../utils/i18n");
var _tools_form_registry = require("./form/registry/tools_form_registry");
var _create_tool = require("./create_tool");
var _test_tools = require("./execute/test_tools");
var _tool_edit_context_menu = require("./form/components/tool_edit_context_menu");
var _tool_form = require("./form/tool_form");
var _use_flyout_state = require("../../hooks/use_flyout_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/tool.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUTTON_IDS = {
  SAVE: 'save',
  SAVE_AND_TEST: 'saveAndTest'
};
const Tool = ({
  mode,
  tool,
  isLoading,
  isSubmitting,
  saveTool
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const {
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  // Resolve state updates before navigation to avoid triggering unsaved changes prompt
  const deferNavigateToOnechatUrl = (0, _react2.useCallback)((...args) => {
    (0, _lodash.defer)(() => navigateToOnechatUrl(...args));
  }, [navigateToOnechatUrl]);
  const [openTestFlyoutParam, setOpenTestFlyoutParam] = (0, _use_query_state.useQueryState)(_create_tool.OPEN_TEST_FLYOUT_QUERY_PARAM, {
    defaultValue: false
  });
  const [urlToolType, setUrlToolType] = (0, _use_query_state.useQueryState)(_create_tool.TOOL_TYPE_QUERY_PARAM);
  const initialToolType = (0, _react2.useMemo)(() => {
    if (urlToolType && (0, _tools_form_registry.getToolTypeConfig)(urlToolType)) {
      return urlToolType;
    }
    return undefined;
  }, [urlToolType]);
  const form = (0, _use_tool_form.useToolForm)(tool, initialToolType);
  const {
    reset,
    formState,
    watch,
    handleSubmit,
    getValues
  } = form;
  const {
    errors,
    isDirty,
    isSubmitSuccessful
  } = formState;
  const [isCancelling, setIsCancelling] = (0, _react2.useState)(false);
  const {
    isOpen: showTestFlyout,
    openFlyout: openTestFlyout,
    closeFlyout: closeTestFlyout
  } = (0, _use_flyout_state.useFlyoutState)(false);
  const [submittingButtonId, setSubmittingButtonId] = (0, _react2.useState)();
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    application: {
      navigateToUrl
    },
    overlays: {
      openConfirm
    },
    http,
    appParams: {
      history
    }
  } = services;
  const currentToolId = watch('toolId');

  // Handle opening test tool flyout on navigation
  (0, _react2.useEffect)(() => {
    if (openTestFlyoutParam && currentToolId && !showTestFlyout) {
      openTestFlyout();
      setOpenTestFlyoutParam(false);
    }
  }, [openTestFlyoutParam, currentToolId, showTestFlyout, setOpenTestFlyoutParam, openTestFlyout]);
  const handleCancel = (0, _react2.useCallback)(() => {
    setIsCancelling(true);
    deferNavigateToOnechatUrl(_app_paths.appPaths.tools.list);
  }, [deferNavigateToOnechatUrl]);
  const handleSave = (0, _react2.useCallback)(async (data, {
    navigateToListView = true,
    buttonId = BUTTON_IDS.SAVE
  } = {}) => {
    if (mode === _tool_form.ToolFormMode.View) return;
    setSubmittingButtonId(buttonId);
    try {
      if (mode === _tool_form.ToolFormMode.Edit) {
        const updatePayload = (0, _tools_form_registry.getUpdatePayloadFromData)(data);
        await saveTool(updatePayload);
      } else {
        const createPayload = (0, _tools_form_registry.getCreatePayloadFromData)(data);
        await saveTool(createPayload);
      }
    } finally {
      setSubmittingButtonId(undefined);
    }
    if (navigateToListView) {
      deferNavigateToOnechatUrl(_app_paths.appPaths.tools.list);
    }
  }, [mode, saveTool, deferNavigateToOnechatUrl]);
  const handleTestTool = (0, _react2.useCallback)(() => {
    openTestFlyout();
  }, [openTestFlyout]);
  const handleSaveAndTest = (0, _react2.useCallback)(async data => {
    await handleSave(data, {
      navigateToListView: false,
      buttonId: BUTTON_IDS.SAVE_AND_TEST
    });
    handleTestTool();
  }, [handleSave, handleTestTool]);
  (0, _react2.useEffect)(() => {
    if (tool) {
      const toolTypeConfig = (0, _tools_form_registry.getToolTypeConfig)(tool.type);
      if (toolTypeConfig) {
        const {
          toolToFormData
        } = toolTypeConfig;
        reset(toolToFormData(tool));
      }
    }
  }, [tool, reset]);

  // Switching tool types clears tool-specific fields
  (0, _react2.useEffect)(() => {
    if (!urlToolType) return;
    if (mode !== _tool_form.ToolFormMode.Create) return;
    const currentValues = getValues();
    const newDefaultValues = (0, _tools_form_registry.getToolTypeDefaultValues)(urlToolType);
    const mergedValues = {
      ...newDefaultValues,
      toolId: currentValues.toolId,
      description: currentValues.description,
      labels: currentValues.labels
    };
    reset(mergedValues);
  }, [urlToolType, initialToolType, mode, getValues, reset]);
  const toolFormId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'toolForm'
  });
  const isViewMode = mode === _tool_form.ToolFormMode.View;
  const hasErrors = Object.keys(errors).length > 0;
  const renderSaveButton = (0, _react2.useCallback)(({
    size = 's'
  } = {}) => {
    const saveButton = /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      size: size,
      type: "submit",
      fill: true,
      iconType: "save",
      form: toolFormId,
      disabled: hasErrors || isSubmitting || mode === _tool_form.ToolFormMode.Edit && !isDirty,
      isLoading: submittingButtonId === BUTTON_IDS.SAVE,
      minWidth: "112px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 9
      }
    }, _i18n2.labels.tools.saveButtonLabel);
    return hasErrors ? /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      display: "block",
      content: _i18n2.labels.tools.saveButtonTooltip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 9
      }
    }, saveButton) : saveButton;
  }, [toolFormId, hasErrors, isSubmitting, mode, isDirty, submittingButtonId]);
  const renderTestButton = (0, _react2.useCallback)(({
    size = 's'
  } = {}) => {
    const isCreateMode = mode === _tool_form.ToolFormMode.Create;
    const commonProps = {
      size,
      iconType: 'play',
      isDisabled: hasErrors || isSubmitting
    };
    return isCreateMode || isDirty ? /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, commonProps, {
      onClick: handleSubmit(handleSaveAndTest),
      isLoading: submittingButtonId === BUTTON_IDS.SAVE_AND_TEST,
      minWidth: "124px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 9
      }
    }), _i18n2.labels.tools.saveAndTestButtonLabel) : /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, commonProps, {
      onClick: handleTestTool,
      minWidth: "112px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 9
      }
    }), _i18n2.labels.tools.testButtonLabel);
  }, [mode, handleSubmit, handleSaveAndTest, handleTestTool, hasErrors, isSubmitting, submittingButtonId, isDirty]);
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: !isViewMode && isDirty && !isSubmitSuccessful && !isCancelling,
    history,
    http,
    navigateToUrl,
    openConfirm,
    shouldPromptOnReplace: false
  });
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, form, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 17
      }
    }, [_tool_form.ToolFormMode.View, _tool_form.ToolFormMode.Edit].includes(mode) ? tool === null || tool === void 0 ? void 0 : tool.id : _i18n2.labels.tools.newToolTitle), (tool === null || tool === void 0 ? void 0 : tool.readonly) && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "lock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 21
      }
    }, _i18n2.labels.tools.readOnly))),
    description: mode === _tool_form.ToolFormMode.Create ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.tools.createToolDescription",
      defaultMessage: "Give your new tool a unique ID and a clear description, so both humans and LLMs can understand its purpose. Add labels for organization, and write the index pattern or ES|QL query that powers its functionality. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.tools,
          target: "_blank",
          "aria-label": _i18n.i18n.translate('xpack.onechat.tools.createToolDocumentationAriaLabel', {
            defaultMessage: 'Learn more about creating tools in the documentation'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 318,
            columnNumber: 23
          }
        }, _i18n.i18n.translate('xpack.onechat.tools.createToolDocumentation', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 17
      }
    }) : undefined,
    rightSideItems: [...(mode !== _tool_form.ToolFormMode.View ? [renderSaveButton({
      size: 'm'
    })] : []), renderTestButton({
      size: 'm'
    }), ...(mode === _tool_form.ToolFormMode.Edit ? [/*#__PURE__*/_react2.default.createElement(_tool_edit_context_menu.ToolEditContextMenu, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 49
      }
    })] : [])],
    rightSideGroupProps: {
      gutterSize: 's'
    },
    css: (0, _react.css)`
              background-color: ${euiTheme.colors.backgroundBasePlain};
              border-block-end: none;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 11
    }
  }, isLoading ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, isViewMode ? /*#__PURE__*/_react2.default.createElement(_tool_form.ToolForm, {
    mode: _tool_form.ToolFormMode.View,
    formId: toolFormId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react2.default.createElement(_tool_form.ToolForm, {
    mode: mode,
    formId: toolFormId,
    saveTool: handleSave,
    toolType: urlToolType,
    setToolType: setUrlToolType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    css: (0, _react.css)`
                    height: ${!isMobile || isViewMode ? euiTheme.size.xxxxl : '144px'};
                  `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    css: (0, _react.css)`
              z-index: ${euiTheme.levels.header};
            `,
    paddingSize: "m",
    restrictWidth: false,
    position: "fixed",
    usePortal: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 13
    }
  }, mode !== _tool_form.ToolFormMode.View && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n2.labels.tools.cancelButtonLabel,
    size: "s",
    iconType: "cross",
    color: "text",
    onClick: handleCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 19
    }
  }, _i18n2.labels.tools.cancelButtonLabel)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 15
    }
  }, renderTestButton()), mode !== _tool_form.ToolFormMode.View && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 17
    }
  }, renderSaveButton()))))), showTestFlyout && currentToolId && /*#__PURE__*/_react2.default.createElement(_test_tools.ToolTestFlyout, {
    toolId: currentToolId,
    formMode: mode,
    onClose: () => {
      closeTestFlyout();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 9
    }
  }));
};
exports.Tool = Tool;