"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolQuickActionsHoverStyles = exports.ToolQuickActions = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _tools_provider = require("../../../context/tools_provider");
var _i18n = require("../../../utils/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/table/tools_table_quick_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const toolQuickActionsHoverStyles = exports.toolQuickActionsHoverStyles = (0, _react.css)`
  .euiTableRow:hover .tool-quick-actions {
    visibility: visible;
  }
`;
const ToolQuickActions = ({
  tool
}) => {
  const {
    editTool,
    deleteTool
  } = (0, _tools_provider.useToolsActions)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
        visibility: hidden;
      `,
    className: "tool-quick-actions",
    gutterSize: "s",
    alignItems: "center",
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    iconType: "documentEdit",
    onClick: () => {
      editTool(tool.id);
    },
    "aria-label": _i18n.labels.tools.editToolButtonLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    onClick: () => {
      deleteTool(tool.id);
    },
    "aria-label": _i18n.labels.tools.deleteToolButtonLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.ToolQuickActions = ToolQuickActions;