"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatToolsTable = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _use_tools = require("../../../hooks/tools/use_tools");
var _i18n = require("../../../utils/i18n");
var _tools_table_columns = require("./tools_table_columns");
var _tools_table_header = require("./tools_table_header");
var _tools_table_quick_actions = require("./tools_table_quick_actions");
var _tools_table_search = require("./tools_table_search");
var _use_ui_privileges = require("../../../hooks/use_ui_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/table/tools_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OnechatToolsTable = exports.OnechatToolsTable = /*#__PURE__*/(0, _react2.memo)(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    tools,
    isLoading: isLoadingTools,
    error: toolsError
  } = (0, _use_tools.useToolsService)();
  const [tablePageIndex, setTablePageIndex] = (0, _react2.useState)(0);
  const [selectedTools, setSelectedTools] = (0, _react2.useState)([]);
  const {
    searchConfig,
    results: tableTools
  } = (0, _tools_table_search.useToolsTableSearch)();
  const {
    manageTools
  } = (0, _use_ui_privileges.useUiPrivileges)();
  (0, _react2.useEffect)(() => {
    setTablePageIndex(0);
  }, [tableTools]);
  const columns = (0, _react2.useMemo)(() => (0, _tools_table_columns.getToolsTableColumns)({
    canManageTools: manageTools
  }), [manageTools]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiInMemoryTable, {
    css: (0, _react.css)`
        border-top: 1px solid ${euiTheme.colors.borderBaseSubdued};
        table {
          background-color: transparent; /* Ensure top border visibility */
        }
        ${_tools_table_quick_actions.toolQuickActionsHoverStyles}
      `,
    childrenBetween: /*#__PURE__*/_react2.default.createElement(_tools_table_header.ToolsTableHeader, {
      isLoading: isLoadingTools,
      pageIndex: tablePageIndex,
      tools: tableTools,
      total: tools.length,
      selectedTools: selectedTools,
      setSelectedTools: setSelectedTools,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }),
    loading: isLoadingTools,
    columns: columns,
    items: tableTools,
    itemId: "id",
    error: toolsError ? _i18n.labels.tools.listToolsErrorMessage : undefined,
    search: searchConfig,
    onTableChange: ({
      page: {
        index
      }
    }) => {
      setTablePageIndex(index);
    },
    pagination: {
      pageIndex: tablePageIndex,
      pageSize: 10,
      showPerPageOptions: false
    },
    selection: {
      selectable: tool => !tool.readonly,
      onSelectionChange: selectedItems => {
        setSelectedTools(selectedItems);
      },
      selected: selectedTools
    },
    sorting: {
      sort: {
        field: 'id',
        direction: 'asc'
      }
    },
    noItemsMessage: isLoadingTools ? /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      component: "p",
      size: "s",
      textAlign: "center",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }, tools.length > 0 && tableTools.length === 0 ? _i18n.labels.tools.noEsqlToolsMatchMessage : _i18n.labels.tools.noEsqlToolsMessage),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  });
});