"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationAgentSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_agents = require("../../hooks/agents/use_agents");
var _use_conversation = require("../../hooks/use_conversation");
var _use_conversation_actions = require("../../hooks/use_conversation_actions");
var _agent_select_dropdown = require("./agent_select_dropdown");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_agent_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConversationAgentSelector = ({
  agentId
}) => {
  const {
    agents,
    isLoading: isLoadingAgents
  } = (0, _use_agents.useOnechatAgents)();
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const {
    setAgentId
  } = (0, _use_conversation_actions.useConversationActions)();
  const handleAgentChange = newAgentId => {
    setAgentId(newAgentId);
  };
  if (isLoadingAgents || !agentId) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 12
      }
    });
  }
  const currentAgent = agents.find(agent => agent.id === agentId);
  return hasActiveConversation ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, currentAgent === null || currentAgent === void 0 ? void 0 : currentAgent.name) : /*#__PURE__*/_react.default.createElement(_agent_select_dropdown.AgentSelectDropdown, {
    selectedAgent: currentAgent,
    onAgentChange: handleAgentChange,
    agents: agents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
};
exports.ConversationAgentSelector = ConversationAgentSelector;