"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsFlatView = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _i18n2 = require("../../../utils/i18n");
var _tool_tags = require("../../tools/tags/tool_tags");
var _truncate_at_newline = require("../../../utils/truncate_at_newline");
var _tool_selection_utils = require("../../../utils/tool_selection_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/edit/tools_flat_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ToolDetailsColumn = ({
  tool
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
          font-weight: ${euiTheme.font.weight.semiBold};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, tool.id), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, (0, _truncate_at_newline.truncateAtNewline)(tool.description)));
};
const createCheckboxColumn = (selectedTools, onToggleTool, disabled) => ({
  width: '40px',
  render: tool => {
    const toolFields = {
      id: tool.id
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: `tool-${tool.id}`,
      checked: (0, _tool_selection_utils.isToolSelected)(toolFields, selectedTools),
      onChange: () => onToggleTool(tool.id),
      disabled: disabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    });
  }
});
const createToolDetailsColumn = () => ({
  name: _i18n2.labels.tools.toolIdLabel,
  sortable: item => item.id,
  width: '60%',
  render: item => /*#__PURE__*/_react.default.createElement(ToolDetailsColumn, {
    tool: item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 37
    }
  })
});
const createTagsColumn = () => ({
  field: 'tags',
  name: _i18n2.labels.tools.tagsLabel,
  render: tags => /*#__PURE__*/_react.default.createElement(_tool_tags.OnechatToolTags, {
    tags: tags,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 31
    }
  })
});
const ToolsFlatView = ({
  tools,
  selectedTools,
  onToggleTool,
  disabled,
  pageIndex,
  onPageChange
}) => {
  const pageSize = 10;
  const columns = _react.default.useMemo(() => [createCheckboxColumn(selectedTools, onToggleTool, disabled), createToolDetailsColumn(), createTagsColumn()], [selectedTools, onToggleTool, disabled]);
  const handleTableChange = _react.default.useCallback(({
    page: {
      index
    }
  }) => {
    onPageChange(index);
  }, [onPageChange]);
  const noItemsMessage = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    size: "s",
    textAlign: "center",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.onechat.tools.noToolsAvailable', {
    defaultMessage: 'No tools available'
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.tools.toolsSelectionSummary",
    defaultMessage: "Showing {start}-{end} of {total} {tools}",
    values: {
      start: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 22
        }
      }, Math.min(pageIndex * pageSize + 1, tools.length)),
      end: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 20
        }
      }, Math.min((pageIndex + 1) * pageSize, tools.length)),
      total: tools.length,
      tools: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 22
        }
      }, _i18n2.labels.tools.toolsLabel)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: columns,
    items: tools,
    itemId: "id",
    pagination: {
      pageIndex,
      pageSize,
      showPerPageOptions: false
    },
    onTableChange: handleTableChange,
    sorting: {
      sort: {
        field: 'id',
        direction: 'asc'
      }
    },
    noItemsMessage: noItemsMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }));
};
exports.ToolsFlatView = ToolsFlatView;