"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavNameWithBadge = NavNameWithBadge;
exports.hideBadge = hideBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/components/page_template/nav_name_with_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LabelContainer = _styledComponents.default.span`
  max-width: 72%;
  float: left;
  &:hover,
  &:focus {
    text-decoration: underline;
  }
`;
const StyledBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: 8px;
`;

/**
 * Gets current state from local storage to show or hide the badge.
 * Default value: true
 * @param localStorageId
 */
function getBadgeVisibility(localStorageId) {
  const storedItem = window.localStorage.getItem(localStorageId);
  if (storedItem) {
    return JSON.parse(storedItem);
  }
  return true;
}

/**
 * Saves on local storage that this item should no longer be visible
 * @param localStorageId
 */
function hideBadge(localStorageId) {
  window.localStorage.setItem(localStorageId, JSON.stringify(false));
}
function NavNameWithBadge({
  label,
  localStorageId
}) {
  const isBadgeVisible = getBadgeVisibility(localStorageId);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LabelContainer, {
    className: "eui-textTruncate",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, label)), isBadgeVisible && /*#__PURE__*/_react.default.createElement(StyledBadge, {
    color: "accent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.observabilityShared.navigation.newBadge', {
    defaultMessage: 'NEW'
  })));
}