"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validGroupByForContext = exports.shouldTermsAggOnContainer = exports.oneOfLiterals = exports.isTooManyBucketsPreviewException = exports.hasAdditionalContext = exports.getContextForRecoveredAlerts = exports.getAlertDetailsUrl = exports.getAlertDetailsPageEnabledForApp = exports.flattenAdditionalContext = exports.doFieldsExist = exports.createScopedLogger = exports.calculateRateTimeranges = exports.TOO_MANY_BUCKETS_PREVIEW_EXCEPTION = exports.NUMBER_OF_DOCUMENTS = exports.KUBERNETES_POD_UID = exports.INFRA_ALERT_PREVIEW_PATH = exports.CONTAINER_ID = void 0;
var _lodash = require("lodash");
var _configSchema = require("@kbn/config-schema");
var _common = require("@kbn/spaces-plugin/common");
var _fieldTypes = require("@kbn/field-types");
var _objectUtils = require("@kbn/object-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_CONTEXT_CONTAINER = 'container';
const ALERT_CONTEXT_ORCHESTRATOR = 'orchestrator';
const ALERT_CONTEXT_CLOUD = 'cloud';
const ALERT_CONTEXT_HOST = 'host';
const ALERT_CONTEXT_LABELS = 'labels';
const ALERT_CONTEXT_TAGS = 'tags';
const HOST_NAME = 'host.name';
const HOST_HOSTNAME = 'host.hostname';
const HOST_ID = 'host.id';
const CONTAINER_ID = exports.CONTAINER_ID = 'container.id';
const SUPPORTED_ES_FIELD_TYPES = [_fieldTypes.ES_FIELD_TYPES.KEYWORD, _fieldTypes.ES_FIELD_TYPES.IP, _fieldTypes.ES_FIELD_TYPES.BOOLEAN];
const oneOfLiterals = arrayOfLiterals => _configSchema.schema.string({
  validate: value => arrayOfLiterals.includes(value) ? undefined : `must be one of ${arrayOfLiterals.join(' | ')}`
});
exports.oneOfLiterals = oneOfLiterals;
const createScopedLogger = (logger, scope, alertExecutionDetails) => {
  const scopedLogger = logger.get(scope);
  const fmtMsg = msg => `[AlertId: ${alertExecutionDetails.alertId}][ExecutionId: ${alertExecutionDetails.executionId}] ${msg}`;
  return {
    ...scopedLogger,
    info: (msg, meta) => scopedLogger.info(fmtMsg(msg), meta),
    debug: (msg, meta) => scopedLogger.debug(fmtMsg(msg), meta),
    trace: (msg, meta) => scopedLogger.trace(fmtMsg(msg), meta),
    warn: (errorOrMessage, meta) => {
      if ((0, _lodash.isError)(errorOrMessage)) {
        scopedLogger.warn(errorOrMessage, meta);
      } else {
        scopedLogger.warn(fmtMsg(errorOrMessage), meta);
      }
    },
    error: (errorOrMessage, meta) => {
      if ((0, _lodash.isError)(errorOrMessage)) {
        scopedLogger.error(errorOrMessage, meta);
      } else {
        scopedLogger.error(fmtMsg(errorOrMessage), meta);
      }
    },
    fatal: (errorOrMessage, meta) => {
      if ((0, _lodash.isError)(errorOrMessage)) {
        scopedLogger.fatal(errorOrMessage, meta);
      } else {
        scopedLogger.fatal(fmtMsg(errorOrMessage), meta);
      }
    }
  };
};
exports.createScopedLogger = createScopedLogger;
const getAlertDetailsPageEnabledForApp = (config, appName) => {
  if (!config) return false;
  return config[appName].enabled;
};
exports.getAlertDetailsPageEnabledForApp = getAlertDetailsPageEnabledForApp;
const getAlertDetailsUrl = (basePath, spaceId, alertUuid) => (0, _common.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, `/app/observability/alerts/${alertUuid}`);
exports.getAlertDetailsUrl = getAlertDetailsUrl;
const KUBERNETES_POD_UID = exports.KUBERNETES_POD_UID = 'kubernetes.pod.uid';
const NUMBER_OF_DOCUMENTS = exports.NUMBER_OF_DOCUMENTS = 10;
const doFieldsExist = async (esClient, fields, index) => {
  // Get all supported fields
  const respMapping = await esClient.fieldCaps({
    index,
    fields
  });
  const fieldsExisted = {};
  const acceptableFields = new Set();
  Object.entries(respMapping.fields).forEach(([key, value]) => {
    const fieldTypes = Object.keys(value);
    const isSupportedType = fieldTypes.some(type => SUPPORTED_ES_FIELD_TYPES.includes(type));

    // Check if fieldName is something we can aggregate on
    if (isSupportedType) {
      acceptableFields.add(key);
    }
  });
  fields.forEach(field => {
    fieldsExisted[field] = acceptableFields.has(field);
  });
  return fieldsExisted;
};
exports.doFieldsExist = doFieldsExist;
const validGroupByForContext = exports.validGroupByForContext = [HOST_NAME, HOST_HOSTNAME, HOST_ID, KUBERNETES_POD_UID, CONTAINER_ID];
const hasAdditionalContext = (groupBy, validGroups) => {
  return groupBy ? Array.isArray(groupBy) ? groupBy.some(group => validGroups.includes(group)) : validGroups.includes(groupBy) : false;
};
exports.hasAdditionalContext = hasAdditionalContext;
const shouldTermsAggOnContainer = groupBy => {
  return groupBy && Array.isArray(groupBy) ? groupBy.includes(KUBERNETES_POD_UID) : groupBy === KUBERNETES_POD_UID;
};
exports.shouldTermsAggOnContainer = shouldTermsAggOnContainer;
const flattenAdditionalContext = additionalContext => {
  return additionalContext ? (0, _objectUtils.flattenObject)(additionalContext) : {};
};
exports.flattenAdditionalContext = flattenAdditionalContext;
const getContextForRecoveredAlerts = alertHitSource => {
  const alert = alertHitSource ? (0, _objectUtils.unflattenObject)(alertHitSource) : undefined;
  return {
    cloud: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_CLOUD],
    host: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_HOST],
    orchestrator: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_ORCHESTRATOR],
    container: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_CONTAINER],
    labels: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_LABELS],
    tags: alert === null || alert === void 0 ? void 0 : alert[ALERT_CONTEXT_TAGS]
  };
};

// TO BE MOVED
exports.getContextForRecoveredAlerts = getContextForRecoveredAlerts;
const INFRA_ALERT_PREVIEW_PATH = exports.INFRA_ALERT_PREVIEW_PATH = '/api/infra/alerting/preview';
const TOO_MANY_BUCKETS_PREVIEW_EXCEPTION = exports.TOO_MANY_BUCKETS_PREVIEW_EXCEPTION = 'TOO_MANY_BUCKETS_PREVIEW_EXCEPTION';
const isTooManyBucketsPreviewException = value => Boolean(value && value.TOO_MANY_BUCKETS_PREVIEW_EXCEPTION);
exports.isTooManyBucketsPreviewException = isTooManyBucketsPreviewException;
const calculateRateTimeranges = timerange => {
  // This is the total number of milliseconds for the entire timerange
  const totalTime = timerange.to - timerange.from;
  // Halfway is the to minus half the total time;
  const halfway = Math.round(timerange.to - totalTime / 2);
  // The interval is half the total time (divided by 1000 to convert to seconds)
  const intervalInSeconds = Math.round(totalTime / (2 * 1000));

  // The first bucket is from the beginning of the time range to the halfway point
  const firstBucketRange = {
    from: timerange.from,
    to: halfway
  };

  // The second bucket is from the halfway point to the end of the timerange
  const secondBucketRange = {
    from: halfway,
    to: timerange.to
  };
  return {
    firstBucketRange,
    secondBucketRange,
    intervalInSeconds
  };
};
exports.calculateRateTimeranges = calculateRateTimeranges;