"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnhancedRulesCallout = EnhancedRulesCallout;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _paths = require("../../../common/locators/paths");
var _kibana_react = require("../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/rules/enhanced_rules_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EnhancedRulesCallout({
  ruleTypeId
}) {
  const {
    http,
    application
  } = (0, _kibana_react.useKibana)().services;
  if (!ruleTypeId || !SHOW_ENHANCED_RULES_CALLOUT_RULE_TYPES.includes(ruleTypeId)) return null;
  const handleCreateRuleClick = enhancedRuleTypeId => {
    application.navigateToUrl(http.basePath.prepend(_paths.paths.observability.createRule(enhancedRuleTypeId)));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: CALLOUT_TITLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, CALLOUT_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enhancedRulesCallout-createCTRRuleButton",
    onClick: () => handleCreateRuleClick(_ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, CREATE_CTR_RULE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enhancedRulesCallout-createESQRuleButton",
    onClick: () => handleCreateRuleClick(_ruleDataUtils.ES_QUERY_ID),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, CREATE_ESQ_RULE_LABEL)));
}
const SHOW_ENHANCED_RULES_CALLOUT_RULE_TYPES = [_ruleDataUtils.METRIC_THRESHOLD_ALERT_TYPE_ID, _ruleDataUtils.LOG_THRESHOLD_ALERT_TYPE_ID, _ruleDataUtils.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID];
const CALLOUT_TITLE = _i18n.i18n.translate('xpack.observability.enhancedRulesCallout.title', {
  defaultMessage: 'Try our enhanced rules instead'
});
const CALLOUT_DESCRIPTION = _i18n.i18n.translate('xpack.observability.enhancedRulesCallout.description', {
  defaultMessage: 'Consider using the Custom threshold rule or Elasticsearch query rule, which offer more flexibility and customization options.'
});
const CREATE_CTR_RULE_LABEL = _i18n.i18n.translate('xpack.observability.enhancedRulesCallout.createCTRule', {
  defaultMessage: 'Create Custom threshold rule'
});
const CREATE_ESQ_RULE_LABEL = _i18n.i18n.translate('xpack.observability.enhancedRulesCallout.createESQRule', {
  defaultMessage: 'Create Elasticsearch query rule'
});