"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HasDataContext = void 0;
exports.HasDataContextProvider = HasDataContextProvider;
exports.appLabels = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _std = require("@kbn/std");
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../utils/kibana_react");
var _constants = require("../constants");
var _data_handler = require("./data_handler");
var _use_date_picker_context = require("../../hooks/use_date_picker_context");
var _get_observability_alerts = require("./get_observability_alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/context/has_data_context/has_data_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HasDataContext = exports.HasDataContext = /*#__PURE__*/(0, _react.createContext)({});
const apps = [_constants.APM_APP, _constants.UPTIME_APP, _constants.INFRA_LOGS_APP, _constants.INFRA_METRICS_APP, _constants.UX_APP, _constants.ALERT_APP, _constants.UNIVERSAL_PROFILING_APP];
const appLabels = exports.appLabels = {
  alert: _i18n.i18n.translate('xpack.observability.overview.alertsLabel', {
    defaultMessage: 'Alerts'
  }),
  apm: _i18n.i18n.translate('xpack.observability.overview.apmLabel', {
    defaultMessage: 'APM'
  }),
  infra_logs: _i18n.i18n.translate('xpack.observability.overview.logsLabel', {
    defaultMessage: 'Logs'
  }),
  infra_metrics: _i18n.i18n.translate('xpack.observability.overview.metricsLabel', {
    defaultMessage: 'Metrics'
  }),
  universal_profiling: _i18n.i18n.translate('xpack.observability.overview.profilingLabel', {
    defaultMessage: 'Profiling'
  }),
  uptime: _i18n.i18n.translate('xpack.observability.overview.uptimeLabel', {
    defaultMessage: 'Uptime'
  }),
  ux: _i18n.i18n.translate('xpack.observability.overview.uxLabel', {
    defaultMessage: 'UX'
  })
};
function HasDataContextProvider({
  children
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const [forceUpdate, setForceUpdate] = (0, _react.useState)('');
  const {
    absoluteStart,
    absoluteEnd
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const [hasDataMap, setHasDataMap] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    (0, _std.asyncForEach)(apps, async app => {
      var _getDataHandler, _getDataHandler2, _getDataHandler3, _getDataHandler4, _getDataHandler5;
      try {
        const updateState = ({
          hasData,
          indices,
          serviceName
        }) => {
          setHasDataMap(prevState => ({
            ...prevState,
            [app]: {
              hasData,
              ...(serviceName ? {
                serviceName
              } : {}),
              ...(indices ? {
                indices
              } : {}),
              status: _public.FETCH_STATUS.SUCCESS
            }
          }));
        };
        switch (app) {
          case _constants.UX_APP:
            const params = {
              absoluteTime: {
                start: absoluteStart,
                end: absoluteEnd
              }
            };
            const resultUx = await ((_getDataHandler = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.hasData(params));
            updateState({
              hasData: resultUx === null || resultUx === void 0 ? void 0 : resultUx.hasData,
              indices: resultUx === null || resultUx === void 0 ? void 0 : resultUx.indices,
              serviceName: resultUx === null || resultUx === void 0 ? void 0 : resultUx.serviceName
            });
            break;
          case _constants.UPTIME_APP:
            const resultSy = await ((_getDataHandler2 = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler2 === void 0 ? void 0 : _getDataHandler2.hasData());
            updateState({
              hasData: resultSy === null || resultSy === void 0 ? void 0 : resultSy.hasData,
              indices: resultSy === null || resultSy === void 0 ? void 0 : resultSy.indices
            });
            break;
          case _constants.APM_APP:
            const resultApm = await ((_getDataHandler3 = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler3 === void 0 ? void 0 : _getDataHandler3.hasData());
            updateState({
              hasData: resultApm === null || resultApm === void 0 ? void 0 : resultApm.hasData,
              indices: resultApm === null || resultApm === void 0 ? void 0 : resultApm.indices
            });
            break;
          case _constants.INFRA_LOGS_APP:
            const resultInfraLogs = await ((_getDataHandler4 = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler4 === void 0 ? void 0 : _getDataHandler4.hasData());
            updateState({
              hasData: resultInfraLogs === null || resultInfraLogs === void 0 ? void 0 : resultInfraLogs.hasData,
              indices: resultInfraLogs === null || resultInfraLogs === void 0 ? void 0 : resultInfraLogs.indices
            });
            break;
          case _constants.INFRA_METRICS_APP:
            const resultInfraMetrics = await ((_getDataHandler5 = (0, _data_handler.getDataHandler)(app)) === null || _getDataHandler5 === void 0 ? void 0 : _getDataHandler5.hasData());
            updateState({
              hasData: resultInfraMetrics === null || resultInfraMetrics === void 0 ? void 0 : resultInfraMetrics.hasData,
              indices: resultInfraMetrics === null || resultInfraMetrics === void 0 ? void 0 : resultInfraMetrics.indices
            });
            break;
          case _constants.UNIVERSAL_PROFILING_APP:
            // Profiling only shows the empty section for now
            updateState({
              hasData: false
            });
            break;
        }
      } catch (e) {
        setHasDataMap(prevState => ({
          ...prevState,
          [app]: {
            hasData: undefined,
            status: _public.FETCH_STATUS.FAILURE
          }
        }));
      }
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  (0, _react.useEffect)(() => {
    async function fetchAlerts() {
      try {
        const alerts = await (0, _get_observability_alerts.getObservabilityAlerts)({
          http
        });
        setHasDataMap(prevState => ({
          ...prevState,
          [_constants.ALERT_APP]: {
            hasData: alerts.length > 0,
            status: _public.FETCH_STATUS.SUCCESS
          }
        }));
      } catch (e) {
        setHasDataMap(prevState => ({
          ...prevState,
          [_constants.ALERT_APP]: {
            hasData: undefined,
            status: _public.FETCH_STATUS.FAILURE
          }
        }));
      }
    }
    fetchAlerts();
  }, [forceUpdate, http]);
  const isAllRequestsComplete = apps.every(app => {
    var _hasDataMap$app;
    const appStatus = (_hasDataMap$app = hasDataMap[app]) === null || _hasDataMap$app === void 0 ? void 0 : _hasDataMap$app.status;
    return appStatus !== undefined && appStatus !== _public.FETCH_STATUS.LOADING;
  });
  const hasAnyData = Object.keys(hasDataMap).some(app => {
    var _hasDataMap$app2;
    const appHasData = (_hasDataMap$app2 = hasDataMap[app]) === null || _hasDataMap$app2 === void 0 ? void 0 : _hasDataMap$app2.hasData;
    return appHasData === true;
  });
  return /*#__PURE__*/_react.default.createElement(HasDataContext.Provider, {
    value: {
      hasDataMap,
      hasAnyData: (0, _lodash.isEmpty)(hasDataMap) ? undefined : hasAnyData,
      isAllRequestsComplete,
      forceUpdate,
      onRefreshTimeRange: () => {
        setForceUpdate((0, _lodash.uniqueId)());
      }
    },
    children: children,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 5
    }
  });
}