"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildInstallStackCommand = buildInstallStackCommand;
var _build_values_file_url = require("./build_values_file_url");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildInstallStackCommand({
  isMetricsOnboardingEnabled,
  isManagedOtlpServiceAvailable,
  managedOtlpEndpointUrl,
  elasticsearchUrl,
  apiKeyEncoded,
  agentVersion
}) {
  const ingestEndpointUrl = isManagedOtlpServiceAvailable ? managedOtlpEndpointUrl : elasticsearchUrl;
  const elasticEndpointVarName = isManagedOtlpServiceAvailable ? 'elastic_otlp_endpoint' : 'elastic_endpoint';
  const otelKubeStackValuesFileUrl = (0, _build_values_file_url.buildValuesFileUrl)({
    isMetricsOnboardingEnabled,
    isManagedOtlpServiceAvailable,
    agentVersion
  });
  return `kubectl create namespace ${_constants.OTEL_STACK_NAMESPACE}
kubectl create secret generic elastic-secret-otel \\
  --namespace ${_constants.OTEL_STACK_NAMESPACE} \\
  --from-literal=${elasticEndpointVarName}='${ingestEndpointUrl}' \\
  --from-literal=elastic_api_key='${apiKeyEncoded}'
helm upgrade --install opentelemetry-kube-stack open-telemetry/opentelemetry-kube-stack \\
  --namespace ${_constants.OTEL_STACK_NAMESPACE} \\
  --values '${otelKubeStackValuesFileUrl}' \\
  --version '${_constants.OTEL_KUBE_STACK_VERSION}'`;
}