"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCustomCards = useCustomCards;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _common = require("@kbn/observability-plugin/common");
var _pricing_features = require("../../../common/pricing_features");
var _logo_icon = require("../shared/logo_icon");
var _use_pricing_feature = require("../quickstart_flows/shared/use_pricing_feature");
var _use_managed_otlp_service_availability = require("../shared/use_managed_otlp_service_availability");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/onboarding_flow_form/use_custom_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function useCustomCards(createCollectionCardHandler) {
  var _http$staticAssets$ge, _http$staticAssets$ge2, _http$staticAssets$ge3, _syntheticsLocator$ge;
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDomV5Compat.useLocation)();
  const {
    services: {
      application,
      http,
      context: {
        isServerless,
        isCloud
      },
      share
    }
  } = (0, _public.useKibana)();
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const getUrlForApp = application === null || application === void 0 ? void 0 : application.getUrlForApp;
  const metricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  const isManagedOtlpServiceAvailable = (0, _use_managed_otlp_service_availability.useManagedOtlpServiceAvailability)();
  const {
    href: autoDetectUrl
  } = (0, _public.reactRouterNavigate)(history, `/auto-detect/${location.search}`);
  const {
    href: otelLogsUrl
  } = (0, _public.reactRouterNavigate)(history, `/otel-logs/${location.search}`);
  const {
    href: kubernetesUrl
  } = (0, _public.reactRouterNavigate)(history, `/kubernetes/${location.search}`);
  const {
    href: otelKubernetesUrl
  } = (0, _public.reactRouterNavigate)(history, `/otel-kubernetes/${location.search}`);
  const {
    href: firehoseUrl
  } = (0, _public.reactRouterNavigate)(history, `/firehose/${location.search}`);
  const {
    href: otelApmQuickstartUrl
  } = (0, _public.reactRouterNavigate)(history, `/otel-apm/${location.search}`);
  const apmUrl = `${getUrlForApp === null || getUrlForApp === void 0 ? void 0 : getUrlForApp('apm')}/${isServerless ? 'onboarding' : 'tutorial'}`;
  const otelApmUrl = isManagedOtlpServiceAvailable ? otelApmQuickstartUrl : apmUrl;
  const syntheticsLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_common.syntheticsAddMonitorLocatorID);
  const firehoseQuickstartCard = {
    id: 'firehose-quick-start',
    name: 'firehose-quick-start',
    type: 'virtual',
    title: _i18n.i18n.translate('xpack.observability_onboarding.packageList.uploadFileTitle', {
      defaultMessage: 'AWS Firehose'
    }),
    description: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.packageList.uploadFileDescription', {
      defaultMessage: 'Collect logs and metrics from Amazon Web Services (AWS).'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.packageList.uploadFileDescription', {
      defaultMessage: 'Collect logs from Amazon Web Services (AWS).'
    }),
    categories: ['observability'],
    icons: [{
      type: 'svg',
      src: 'https://epr.elastic.co/package/awsfirehose/1.1.0/img/logo_firehose.svg'
    }],
    url: firehoseUrl,
    version: '',
    integration: '',
    isQuickstart: true
  };
  return [{
    id: 'auto-detect-logs',
    name: 'auto-detect-logs-virtual',
    type: 'virtual',
    title: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.autoDetectTitle', {
      defaultMessage: 'Elastic Agent: Logs & Metrics'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.useCustomCardsForCategory.autoDetectTitle', {
      defaultMessage: 'Elastic Agent: Logs'
    }),
    description: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.autoDetectDescription', {
      defaultMessage: 'Scan your host for log files, metrics, auto-install integrations'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.useCustomCardsForCategory.autoDetectDescription', {
      defaultMessage: 'Scan your host for log files and auto-install integrations'
    }),
    extraLabelsBadges: [/*#__PURE__*/_react.default.createElement(ExtraLabelBadgeWrapper, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }, colorMode === 'DARK' ? /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
      logo: "apple_white",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
      logo: "apple_black",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(ExtraLabelBadgeWrapper, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
      logo: "linux",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 11
      }
    }))],
    categories: ['observability'],
    icons: [{
      type: 'eui',
      src: 'agentApp'
    }],
    url: autoDetectUrl,
    version: '',
    integration: '',
    isQuickstart: true
  }, {
    id: 'otel-logs',
    name: 'custom-logs-virtual',
    type: 'virtual',
    title: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.logsOtelTitle', {
      defaultMessage: 'OpenTelemetry: Logs & Metrics'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.useCustomCardsForCategory.logsOtelTitle', {
      defaultMessage: 'OpenTelemetry: Logs'
    }),
    description: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.logsOtelDescription', {
      defaultMessage: 'Collect logs and host metrics with the Elastic Distro for OTel Collector'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.useCustomCardsForCategory.logsOtelDescription', {
      defaultMessage: 'Collect logs with the Elastic Distro for OTel Collector'
    }),
    extraLabelsBadges: [/*#__PURE__*/_react.default.createElement(ExtraLabelBadgeWrapper, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    }, colorMode === 'DARK' ? /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
      logo: "apple_white",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
      logo: "apple_black",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(ExtraLabelBadgeWrapper, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
      logo: "linux",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 11
      }
    }))],
    categories: ['observability'],
    icons: [{
      type: 'svg',
      src: (_http$staticAssets$ge = http === null || http === void 0 ? void 0 : http.staticAssets.getPluginAssetHref('opentelemetry.svg')) !== null && _http$staticAssets$ge !== void 0 ? _http$staticAssets$ge : ''
    }],
    url: otelLogsUrl,
    version: '',
    integration: '',
    isQuickstart: true
  }, {
    id: 'kubernetes-quick-start',
    name: 'kubernetes-quick-start',
    type: 'virtual',
    title: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.kubernetesTitle', {
      defaultMessage: 'Elastic Agent: Logs & Metrics'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.useCustomCardsForCategory.kubernetesTitle', {
      defaultMessage: 'Elastic Agent: Logs'
    }),
    description: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.kubernetesDescription', {
      defaultMessage: 'Collect logs and metrics from Kubernetes using Elastic Agent'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.useCustomCardsForCategory.kubernetesDescription', {
      defaultMessage: 'Collect logs from Kubernetes using Elastic Agent'
    }),
    extraLabelsBadges: [/*#__PURE__*/_react.default.createElement(ExtraLabelBadgeWrapper, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
      logo: "kubernetes",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 11
      }
    }))],
    categories: ['observability'],
    icons: [{
      type: 'eui',
      src: 'agentApp'
    }],
    url: kubernetesUrl,
    version: '',
    integration: '',
    isQuickstart: true
  }, {
    id: 'otel-kubernetes',
    name: 'otel-kubernetes-virtual',
    type: 'virtual',
    title: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.kubernetesOtelTitle', {
      defaultMessage: 'OpenTelemetry: Full Observability'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.useCustomCardsForCategory.kubernetesOtelTitle', {
      defaultMessage: 'OpenTelemetry: Logs'
    }),
    description: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.kubernetesOtelDescription', {
      defaultMessage: 'Collect logs, traces and metrics with the Elastic Distro for OTel Collector'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.useCustomCardsForCategory.kubernetesOtelDescription', {
      defaultMessage: 'Collect logs with the Elastic Distro for OTel Collector'
    }),
    extraLabelsBadges: [/*#__PURE__*/_react.default.createElement(ExtraLabelBadgeWrapper, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
      logo: "kubernetes",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 11
      }
    }))],
    categories: ['observability'],
    icons: [{
      type: 'svg',
      src: (_http$staticAssets$ge2 = http === null || http === void 0 ? void 0 : http.staticAssets.getPluginAssetHref('opentelemetry.svg')) !== null && _http$staticAssets$ge2 !== void 0 ? _http$staticAssets$ge2 : ''
    }],
    url: otelKubernetesUrl,
    version: '',
    integration: '',
    isQuickstart: true
  }, {
    id: 'otel-virtual',
    type: 'virtual',
    title: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.apmOtelTitle', {
      defaultMessage: 'OpenTelemetry'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.apmOtelDescription', {
      defaultMessage: 'Monitor your applications with OpenTelemetry SDK'
    }),
    name: 'otel',
    categories: ['observability'],
    icons: [{
      type: 'svg',
      src: (_http$staticAssets$ge3 = http === null || http === void 0 ? void 0 : http.staticAssets.getPluginAssetHref('opentelemetry.svg')) !== null && _http$staticAssets$ge3 !== void 0 ? _http$staticAssets$ge3 : ''
    }],
    url: otelApmUrl,
    version: '',
    integration: ''
  }, {
    id: 'apm-virtual',
    type: 'virtual',
    title: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.apmTitle', {
      defaultMessage: 'Elastic APM'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.apmDescription', {
      defaultMessage: 'Collect distributed traces from your applications with Elastic APM'
    }),
    name: 'apm',
    categories: ['observability'],
    icons: [{
      type: 'eui',
      src: 'apmApp'
    }],
    url: apmUrl,
    version: '',
    integration: ''
  }, {
    id: 'synthetics-virtual',
    type: 'virtual',
    title: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.syntheticsTitle', {
      defaultMessage: 'Synthetic monitor'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.syntheticsDescription', {
      defaultMessage: 'Monitor endpoints, pages, and user journeys'
    }),
    name: 'synthetics',
    categories: ['observability'],
    icons: [{
      type: 'eui',
      src: 'logoUptime'
    }],
    url: (_syntheticsLocator$ge = syntheticsLocator === null || syntheticsLocator === void 0 ? void 0 : syntheticsLocator.getRedirectUrl({
      scope: 'create'
    })) !== null && _syntheticsLocator$ge !== void 0 ? _syntheticsLocator$ge : '',
    version: '',
    integration: ''
  }, {
    id: 'azure-logs-virtual',
    type: 'virtual',
    title: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.azureTitle', {
      defaultMessage: 'Azure'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.azureDescription', {
      defaultMessage: 'Collect logs from Microsoft Azure'
    }),
    name: 'azure',
    categories: ['observability'],
    icons: [],
    url: 'https://azure.com',
    version: '',
    integration: '',
    isCollectionCard: true,
    onCardClick: createCollectionCardHandler('azure')
  }, {
    id: 'aws-logs-virtual',
    type: 'virtual',
    title: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.awsTitle', {
      defaultMessage: 'AWS'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.awsDescription', {
      defaultMessage: 'Collect logs from Amazon Web Services (AWS)'
    }),
    name: 'aws',
    categories: ['observability'],
    icons: [],
    url: 'https://aws.com',
    version: '',
    integration: '',
    isCollectionCard: true,
    onCardClick: createCollectionCardHandler('aws')
  }, {
    id: 'gcp-logs-virtual',
    type: 'virtual',
    title: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.gcpTitle', {
      defaultMessage: 'Google Cloud Platform'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.useCustomCardsForCategory.gcpDescription', {
      defaultMessage: 'Collect logs from Google Cloud Platform'
    }),
    name: 'gcp',
    categories: ['observability'],
    icons: [],
    url: '',
    version: '',
    integration: '',
    isCollectionCard: true,
    onCardClick: createCollectionCardHandler('gcp')
  }, {
    id: 'upload-file-virtual',
    type: 'virtual',
    title: _i18n.i18n.translate('xpack.observability_onboarding.packageList.uploadFileTitle', {
      defaultMessage: 'Upload a file'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.packageList.uploadFileDescription', {
      defaultMessage: 'Upload data from a CSV, TSV, JSON or other log file to Elasticsearch for analysis.'
    }),
    name: 'upload-file',
    categories: ['observability'],
    icons: [{
      type: 'eui',
      src: 'addDataApp'
    }],
    url: `${getUrlForApp === null || getUrlForApp === void 0 ? void 0 : getUrlForApp('home')}#/tutorial_directory/fileDataViz`,
    version: '',
    integration: '',
    isCollectionCard: false
  },
  /**
   * The new Firehose card should only be visible on Cloud
   * as Firehose integration requires additional proxy,
   * which is not available for on-prem customers.
   */
  ...(isCloud ? [firehoseQuickstartCard] : [])];
}
function ExtraLabelBadgeWrapper({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      alignSelf: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 5
    }
  }, children);
}