"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuBadges = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu/top_nav_menu_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TopNavMenuBadges = ({
  badges
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!badges || badges.length === 0) return null;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiBadgeGroup, {
    css: (0, _react.css)`
        margin-right: ${euiTheme.size.m};
      `,
    "data-test-subj": "kbn-top-nav-menu-badge-group",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, badges.map(createBadge));
};
exports.TopNavMenuBadges = TopNavMenuBadges;
function createBadge({
  badgeText,
  toolTipProps,
  renderCustomBadge,
  ...badgeProps
}, i) {
  const key = `nav-menu-badge-${i}`;
  const Badge = () => /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
    tabIndex: 0
  }, badgeProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }), badgeText);
  if (renderCustomBadge) {
    return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      key: key,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 12
      }
    }, renderCustomBadge({
      badgeText
    }));
  }
  return toolTipProps ? /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, (0, _extends2.default)({
    key: key
  }, toolTipProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react2.default.createElement(Badge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react2.default.createElement(Badge, {
    key: key,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  });
}