"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assigned = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _shard = require("./shard");
var _get_safe_for_external_link = require("../../../../lib/get_safe_for_external_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/shard_allocation/components/assigned.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const assignedChildrenStyle = ({
  euiTheme
}) => (0, _react2.css)`
  ${(0, _eui.logicalCSS)('padding-top', euiTheme.size.l)}
`;
const childTitleStyle = theme => (0, _react2.css)`
  ${(0, _eui.logicalCSS)('padding', `${theme.euiTheme.size.l} ${theme.euiTheme.size.s}`)}
  text-align: center;
  font-size: ${(0, _eui.euiFontSize)(theme, 'xs').fontSize};
  color: ${theme.euiTheme.colors.ghost};
  display: flex;
  flex-direction: row;
  align-items: center;
`;
const shardStyle = theme => (0, _react2.css)`
  align-self: center;
  ${(0, _eui.logicalCSS)('padding', `${theme.euiTheme.size.xs} ${theme.euiTheme.size.s}`)}
  font-size: ${(0, _eui.euiFontSize)(theme, 'xs').fontSize};
  position: relative;
  display: inline-block;
`;
const childStyle = (data, shardStats) => theme => (0, _react2.css)`
    float: left;
    align-self: center;
    background-color: ${theme.euiTheme.colors.lightestShade};
    margin: ${theme.euiTheme.size.s};
    border: 1px solid ${theme.euiTheme.colors.mediumShade};
    border-radius: ${theme.euiTheme.size.xs};
    ${(0, _eui.logicalCSS)('padding', `calc(${theme.euiTheme.size.xs} / 2) 0`)}

    ${data.type === 'index' && (0, _eui.logicalCSS)('border-left', `${theme.euiTheme.size.xs} solid ${theme.euiTheme.colors.borderStrongSuccess}`)}

    ${(shardStats === null || shardStats === void 0 ? void 0 : shardStats.status) === 'red' && (0, _eui.logicalCSS)('border-left', `${theme.euiTheme.size.xs} solid ${theme.euiTheme.colors.borderStrongDanger}`)}

    ${(shardStats === null || shardStats === void 0 ? void 0 : shardStats.status) === 'yellow' && (0, _eui.logicalCSS)('border-left', `${theme.euiTheme.size.xs} solid ${theme.euiTheme.colors.borderStrongWarning}`)}

    ${data.type === 'shard' && shardStyle(theme)}
  `;
const generateQueryAndLink = data => {
  let type = 'indices';
  let ident = data.name;
  if (data.type === 'node') {
    type = 'nodes';
    ident = data.id;
  }
  return (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/elasticsearch/${type}/${ident}`);
};
function sortByName(item) {
  if (item.type === 'node') {
    return [!item.master, item.name];
  }
  return [item.name];
}
class Assigned extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "createShard", shard => {
      const type = (0, _lodash.get)(shard, 'shard.primary', shard.primary) ? 'primary' : 'replica';
      const key = `${(0, _lodash.get)(shard, 'index.name', shard.index)}.${(0, _lodash.get)(shard, 'node.name', shard.node)}.${type}.${(0, _lodash.get)(shard, 'shard.state', shard.state)}.${(0, _lodash.get)(shard, 'shard.number', shard.shard)}`;
      return /*#__PURE__*/_react.default.createElement(_shard.Shard, {
        shard: shard,
        key: key,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 12
        }
      });
    });
    (0, _defineProperty2.default)(this, "createChild", data => {
      const key = data.id;
      const shardStats = (0, _lodash.get)(this.props.shardStats.indices, key);

      // TODO: redesign for shard allocation
      const name = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: generateQueryAndLink(data),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 18
        }
      }, data.name);
      const master = data.node_type === 'master' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "starFilledSpace",
        color: "primary",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 37
        }
      }) : null;
      const shards = (0, _lodash.sortBy)(data.children, 'shard').map(this.createShard);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        css: childStyle(data, shardStats),
        key: key,
        "data-test-subj": `clusterView-Assigned-${key}`,
        "data-status": shardStats === null || shardStats === void 0 ? void 0 : shardStats.status,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: childTitleStyle,
        grow: false,
        className: "eui-textNoWrap",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 15
        }
      }, name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 15
        }
      }, master))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 13
        }
      }, shards))));
    });
  }
  render() {
    const data = (0, _lodash.sortBy)(this.props.data, sortByName).map(this.createChild);
    return /*#__PURE__*/_react.default.createElement("td", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      css: assignedChildrenStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }, data));
  }
}
exports.Assigned = Assigned;