"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HorizontalLegend = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/chart/horizontal_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const legendItemStyle = isDisabled => theme => (0, _react2.css)`
    display: flex;
    font-size: ${(0, _eui.euiFontSize)(theme, 'xs').fontSize};
    cursor: pointer;
    color: ${theme.euiTheme.colors.textParagraph};
    display: flex;
    flex-direction: row;
    align-items: center;
    ${isDisabled ? 'opacity: 0.5;' : ''}
  `;
const legendHorizontalStyle = ({
  euiTheme
}) => (0, _react2.css)`
  ${(0, _eui.logicalCSS)('margin-top', euiTheme.size.xs)}
`;
const legendLabelStyle = (0, _react2.css)`
  overflow: hidden;
  white-space: nowrap;
  display: flex;
  flex-direction: row;
  align-items: center;
`;
const legendValueStyle = ({
  euiTheme
}) => (0, _react2.css)`
  overflow: hidden;
  white-space: nowrap;
  ${(0, _eui.logicalCSS)('margin-left', euiTheme.size.xs)}
`;
class HorizontalLegend extends _react.default.Component {
  constructor(props) {
    super(props);
    this.formatter = this.formatter.bind(this);
    this.createSeries = this.createSeries.bind(this);
  }

  /**
   * @param {Number} value Final value to display
   */
  displayValue(value) {
    return /*#__PURE__*/_react.default.createElement("span", {
      css: legendValueStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 12
      }
    }, value);
  }

  /**
   * @param {Number} value True if value is falsy and/or not a number
   */
  validValue(value) {
    return value !== null && value !== undefined && (typeof value === 'string' || !isNaN(value));
  }

  /**
   * @param {Number} value The value to format and show in the horizontallegend.
   * A null means no data for the time bucket and will be formatted as 'N/A'
   * @param {Object} row Props passed form a parent by row index
   */
  formatter(value, row) {
    if (!this.validValue(value)) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.chart.horizontalLegend.notAvailableLabel",
        defaultMessage: "N/A",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 9
        }
      });
    }
    if (row !== null && row !== void 0 && row.tickFormatter) {
      return this.displayValue(row.tickFormatter(value));
    }
    const formatter = this.props.legendFormatter || this.props.tickFormatter;
    if ((0, _lodash.isFunction)(formatter)) {
      return this.displayValue(formatter(value));
    }
    return this.displayValue(value);
  }
  createSeries(row, rowIdx) {
    if (!row.label || row.legend === false) {
      return /*#__PURE__*/_react.default.createElement("div", {
        key: rowIdx,
        style: {
          display: 'none'
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: rowIdx,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("button", {
      css: legendItemStyle(!(0, _lodash.includes)(this.props.seriesFilter, row.id)),
      onClick: event => this.props.onToggle(event, row.id),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: legendLabelStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": _i18n.i18n.translate('xpack.monitoring.chart.horizontalLegend.toggleButtonAriaLabel', {
        defaultMessage: 'toggle button'
      }),
      size: "l",
      type: "dot",
      color: row.color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    }), ` ${row.label} `), this.formatter(this.props.seriesValues[row.id], row)));
  }
  render() {
    const rows = this.props.series.map(this.createSeries);
    return /*#__PURE__*/_react.default.createElement("div", {
      css: legendHorizontalStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 9
      }
    }, rows));
  }
}
exports.HorizontalLegend = HorizontalLegend;