"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDefaultQuery = isDefaultQuery;
var _bool_filter_based_simple_query = require("./bool_filter_based_simple_query");
var _match_all_query = require("./match_all_query");
var _simple_query = require("./simple_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if the provided query is a default query. A default query is considered as one that matches all documents,
 * either directly through a `match_all` query, a `SimpleQuery` with a wildcard query string, or a `BoolFilterBasedSimpleQuery`
 * that contains a filter with a wildcard query or a `match_all` condition.
 *
 * @param query - The query to check.
 * @returns True if the query is a default query, false otherwise.
 */
function isDefaultQuery(query) {
  return (0, _match_all_query.isMatchAllQuery)(query) || (0, _simple_query.isSimpleDefaultQuery)(query) || (0, _bool_filter_based_simple_query.isBoolFilterBasedSimpleQuery)(query) && (query.bool.filter[0].query_string.query === '*' || (0, _match_all_query.isMatchAllQuery)(query.bool.filter[0]));
}