"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_ANOMALY_CHARTS_PANEL_ACTION = void 0;
exports.createAddAnomalyChartsPanelAction = createAddAnomalyChartsPanelAction;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _presentationUtil = require("@kbn/presentation-util");
var _public = require("@kbn/ui-actions-plugin/public");
var _app = require("../../common/constants/app");
var _embeddables = require("../embeddables");
var _anomaly_charts_setup_flyout = require("../embeddables/anomaly_charts/anomaly_charts_setup_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/ui_actions/create_anomaly_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EDIT_ANOMALY_CHARTS_PANEL_ACTION = exports.EDIT_ANOMALY_CHARTS_PANEL_ACTION = 'editAnomalyChartsPanelAction';
const parentApiIsCompatible = async parentApi => {
  const {
    apiIsPresentationContainer
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-containers')));
  // we cannot have an async type check, so return the casted parentApi rather than a boolean
  return apiIsPresentationContainer(parentApi) ? parentApi : undefined;
};
function createAddAnomalyChartsPanelAction(getStartServices) {
  return {
    id: 'create-anomaly-charts',
    grouping: [{
      id: _app.PLUGIN_ID,
      getDisplayName: () => _app.ML_APP_NAME,
      getIconType: () => _app.PLUGIN_ICON
    }],
    order: 30,
    getIconType: () => 'anomalyChart',
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.components.mlAnomalyExplorerEmbeddable.displayName', {
      defaultMessage: 'Anomaly chart'
    }),
    getDisplayNameTooltip: () => _i18n.i18n.translate('xpack.ml.components.mlAnomalyExplorerEmbeddable.description', {
      defaultMessage: 'View anomaly detection results in a chart.'
    }),
    async isCompatible(context) {
      return Boolean(await parentApiIsCompatible(context.embeddable));
    },
    async execute(context) {
      const presentationContainerParent = await parentApiIsCompatible(context.embeddable);
      if (!presentationContainerParent) throw new _public.IncompatibleActionError();
      const [coreStart, pluginStart] = await getStartServices();
      (0, _presentationUtil.openLazyFlyout)({
        core: coreStart,
        parentApi: context.embeddable,
        flyoutProps: {
          'data-test-subj': 'mlAnomalyChartsEmbeddableInitializer',
          focusedPanelId: context.embeddable.uuid
        },
        loadContent: async ({
          closeFlyout
        }) => {
          return /*#__PURE__*/_react.default.createElement(_anomaly_charts_setup_flyout.EmbeddableAnomalyChartsUserInput, {
            coreStart: coreStart,
            pluginStart: pluginStart,
            onConfirm: initialState => {
              presentationContainerParent.addNewPanel({
                panelType: _embeddables.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE,
                serializedState: {
                  rawState: initialState
                }
              });
              closeFlyout();
            },
            onCancel: closeFlyout,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 75,
              columnNumber: 13
            }
          });
        }
      });
    }
  };
}