"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleMetricViewerComparators = exports.initializeSingleMetricViewerControls = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const singleMetricViewerComparators = exports.singleMetricViewerComparators = {
  jobIds: 'deepEquality',
  forecastId: 'referenceEquality',
  selectedDetectorIndex: 'referenceEquality',
  selectedEntities: 'deepEquality',
  functionDescription: 'referenceEquality'
};
const initializeSingleMetricViewerControls = (rawState, titlesApi) => {
  var _rawState$selectedDet;
  const functionDescription = new _rxjs.BehaviorSubject(rawState.functionDescription);
  const jobIds = new _rxjs.BehaviorSubject(rawState.jobIds);
  const selectedDetectorIndex = new _rxjs.BehaviorSubject((_rawState$selectedDet = rawState.selectedDetectorIndex) !== null && _rawState$selectedDet !== void 0 ? _rawState$selectedDet : 0);
  const selectedEntities = new _rxjs.BehaviorSubject(rawState.selectedEntities);
  const forecastId = new _rxjs.BehaviorSubject(rawState.forecastId);
  const updateUserInput = update => {
    jobIds.next(update.jobIds);
    functionDescription.next(update.functionDescription);
    selectedDetectorIndex.next(update.selectedDetectorIndex);
    selectedEntities.next(update.selectedEntities);
    titlesApi.setTitle(update.panelTitle);
  };
  const updateForecastId = id => {
    forecastId.next(id);
  };
  const getLatestState = () => {
    return {
      jobIds: jobIds.getValue(),
      forecastId: forecastId.getValue(),
      selectedDetectorIndex: selectedDetectorIndex.getValue(),
      selectedEntities: selectedEntities.getValue(),
      functionDescription: functionDescription === null || functionDescription === void 0 ? void 0 : functionDescription.getValue()
    };
  };
  return {
    api: {
      jobIds,
      forecastId,
      selectedDetectorIndex,
      selectedEntities,
      functionDescription,
      updateForecastId,
      updateUserInput
    },
    anyStateChange$: (0, _rxjs.merge)(jobIds, forecastId, selectedDetectorIndex, selectedEntities, functionDescription).pipe((0, _rxjs.map)(() => undefined)),
    getLatestState,
    reinitializeState: lastSavedState => {
      jobIds.next(lastSavedState.jobIds);
      forecastId.next(lastSavedState.forecastId);
      selectedDetectorIndex.next(lastSavedState.selectedDetectorIndex);
      selectedEntities.next(lastSavedState.selectedEntities);
      functionDescription.next(lastSavedState.functionDescription);
    },
    cleanup: () => {
      forecastId.complete();
      jobIds.complete();
      selectedDetectorIndex.complete();
      selectedEntities.complete();
      functionDescription.complete();
    }
  };
};
exports.initializeSingleMetricViewerControls = initializeSingleMetricViewerControls;