"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServices = exports.getAnomalySwimLaneEmbeddableFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _presentationUtil = require("@kbn/presentation-util");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react2 = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _presentationContainers = require("@kbn/presentation-containers");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _ = require("..");
var _constants = require("../../application/explorer/constants");
var _swimlane_container = require("../../application/explorer/swimlane_container");
var _http_service = require("../../application/services/http_service");
var _ui_actions = require("../../ui_actions");
var _build_data_view_publishing_api = require("../common/build_data_view_publishing_api");
var _use_embeddable_execution_context = require("../common/use_embeddable_execution_context");
var _initialize_swim_lane_controls = require("./initialize_swim_lane_controls");
var _initialize_swim_lane_data_fetcher = require("./initialize_swim_lane_data_fetcher");
var _anomaly_swimlane_setup_flyout = require("./anomaly_swimlane_setup_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/anomaly_swimlane/anomaly_swimlane_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Provides the services required by the Anomaly Swimlane Embeddable.
 */
const getServices = async getStartServices => {
  const [[coreStart, pluginsStart], {
    AnomalyDetectorService
  }, {
    AnomalyTimelineService
  }, {
    mlApiProvider
  }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/anomaly_detector_service'))), Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/anomaly_timeline_service'))), Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/ml_api_service')))]);
  const httpService = new _http_service.HttpService(coreStart.http);
  const anomalyDetectorService = new AnomalyDetectorService(httpService);
  const anomalyTimelineService = new AnomalyTimelineService(pluginsStart.data.query.timefilter.timefilter, coreStart.uiSettings, mlApiProvider(httpService));
  return [coreStart, pluginsStart, {
    anomalyDetectorService,
    anomalyTimelineService
  }];
};
exports.getServices = getServices;
const getAnomalySwimLaneEmbeddableFactory = getStartServices => {
  const factory = {
    type: _.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      var _ref, _ref2;
      if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
        throw new Error('Parent API does not have execution context');
      }
      const services = await getServices(getStartServices);
      const [coreStartServices, pluginsStartServices, anomalySwimLaneServices] = services;
      const subscriptions = new _rxjs.Subscription();
      const interval = new _rxjs.BehaviorSubject(undefined);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      const query$ = (_ref = initialState.rawState.query ? new _rxjs.BehaviorSubject(initialState.rawState.query) : parentApi === null || parentApi === void 0 ? void 0 : parentApi.query$) !== null && _ref !== void 0 ? _ref : new _rxjs.BehaviorSubject(undefined);
      const filters$ = (_ref2 = initialState.rawState.filters ? new _rxjs.BehaviorSubject(initialState.rawState.filters) : parentApi === null || parentApi === void 0 ? void 0 : parentApi.filters$) !== null && _ref2 !== void 0 ? _ref2 : new _rxjs.BehaviorSubject(undefined);
      const refresh$ = new _rxjs.BehaviorSubject(undefined);
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState.rawState);
      const swimlaneManager = (0, _initialize_swim_lane_controls.initializeSwimLaneControls)(initialState.rawState, titleManager.api);

      // Helpers for swim lane data fetching
      const chartWidth$ = new _rxjs.BehaviorSubject(undefined);
      function serializeState() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            ...timeRangeManager.getLatestState(),
            ...swimlaneManager.getLatestState()
          },
          references: []
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, timeRangeManager.anyStateChange$, swimlaneManager.anyStateChange$),
        getComparators: () => {
          return {
            ..._presentationPublishing.titleComparators,
            ..._presentationPublishing.timeRangeComparators,
            ..._initialize_swim_lane_controls.swimLaneComparators,
            id: 'skip',
            query: 'skip',
            refreshConfig: 'skip',
            filters: 'skip'
          };
        },
        onReset: lastSaved => {
          timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          if (lastSaved) swimlaneManager.reinitializeState(lastSaved.rawState);
        }
      });
      const api = finalizeApi({
        isEditingEnabled: () => true,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.ml.swimlaneEmbeddable.typeDisplayName', {
          defaultMessage: 'swim lane'
        }),
        onEdit: async () => {
          (0, _presentationUtil.openLazyFlyout)({
            core: coreStartServices,
            parentApi,
            flyoutProps: {
              focusedPanelId: uuid
            },
            loadContent: async ({
              closeFlyout
            }) => {
              return /*#__PURE__*/_react2.default.createElement(_anomaly_swimlane_setup_flyout.AnomalySwimlaneUserInput, {
                coreStart: coreStartServices,
                pluginStart: pluginsStartServices,
                onConfirm: result => {
                  swimlaneManager.api.updateUserInput(result);
                  closeFlyout();
                },
                onCancel: closeFlyout,
                input: {
                  ...titleManager.getLatestState(),
                  ...swimlaneManager.getLatestState()
                },
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 191,
                  columnNumber: 17
                }
              });
            }
          });
        },
        ...titleManager.api,
        ...timeRangeManager.api,
        ...swimlaneManager.api,
        ...unsavedChangesApi,
        query$,
        filters$,
        interval,
        setInterval: v => interval.next(v),
        dataViews$: (0, _build_data_view_publishing_api.buildDataViewPublishingApi)({
          anomalyDetectorService: services[2].anomalyDetectorService,
          dataViewsService: services[1].data.dataViews
        }, {
          jobIds: swimlaneManager.api.jobIds
        }, subscriptions),
        dataLoading$,
        serializeState
      });
      const appliedTimeRange$ = (0, _rxjs.combineLatest)([api.timeRange$, (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiPublishesTimeRange)(api.parentApi) ? api.parentApi.timeRange$ : (0, _rxjs.of)(null), (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiPublishesTimeslice)(api.parentApi) ? api.parentApi.timeslice$ : (0, _rxjs.of)(null)]).pipe(
      // @ts-ignore
      (0, _rxjs.map)(([timeRange, parentTimeRange, parentTimeslice]) => {
        if (timeRange) {
          return timeRange;
        }
        if (parentTimeRange) {
          return parentTimeRange;
        }
        if (parentTimeslice) {
          return parentTimeslice;
        }
        return undefined;
      }));
      const {
        swimLaneData$,
        onDestroy
      } = (0, _initialize_swim_lane_data_fetcher.initializeSwimLaneDataFetcher)(api, chartWidth$.asObservable(), dataLoading$, blockingError$, appliedTimeRange$, query$, filters$, refresh$, anomalySwimLaneServices);
      subscriptions.add((0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.map)(fetchContext => ({
        query: fetchContext.query,
        filters: fetchContext.filters,
        timeRange: fetchContext.timeRange
      })), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default)).subscribe(() => {
        api.updatePagination({
          fromPage: 1
        });
      }));
      return {
        api,
        Component: () => {
          const {
            uiSettings
          } = coreStartServices;
          const {
            uiActions
          } = pluginsStartServices;
          const timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            throw new Error('Parent API does not have execution context');
          }
          (0, _use_embeddable_execution_context.useReactEmbeddableExecutionContext)(services[0].executionContext, parentApi.executionContext, _.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE, uuid);
          (0, _useUnmount.default)(() => {
            swimlaneManager.cleanup();
            onDestroy();
            subscriptions.unsubscribe();
          });
          const [fromPage, perPage, swimlaneType, swimlaneData, error, isLoading] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.fromPage, api.perPage, api.swimlaneType, swimLaneData$, blockingError$, dataLoading$);
          const [selectedCells, setSelectedCells] = (0, _react2.useState)();
          const [hasRendered, setHasRendered] = (0, _react2.useState)(false);
          const wrapperRef = (0, _react2.useRef)(null);
          (0, _react2.useEffect)(() => {
            if (isLoading) setHasRendered(false);
          }, [isLoading]);
          (0, _react2.useEffect)(function dispatchRenderMessages() {
            const el = wrapperRef.current;
            if (!el) return;
            if (error) {
              (0, _public2.dispatchRenderComplete)(el);
              return;
            }
            if (isLoading) {
              (0, _public2.dispatchRenderStart)(el);
              return;
            }
            if (hasRendered) {
              (0, _public2.dispatchRenderComplete)(el);
            }
          }, [isLoading, hasRendered, error]);
          const onCellsSelection = (0, _react2.useCallback)(update => {
            setSelectedCells(update);
            if (update) {
              uiActions.getTrigger(_ui_actions.SWIM_LANE_SELECTION_TRIGGER).exec({
                embeddable: api,
                data: update,
                updateCallback: setSelectedCells.bind(null, undefined)
              });
            }
          },
          // eslint-disable-next-line react-hooks/exhaustive-deps
          [swimlaneData, perPage, setSelectedCells]);
          return /*#__PURE__*/_react2.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStartServices, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 353,
              columnNumber: 13
            }
          }), /*#__PURE__*/_react2.default.createElement(_public.KibanaContextProvider, {
            services: {
              ...coreStartServices
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 354,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react2.default.createElement("div", {
            css: (0, _react.css)`
                    width: 100%;
                    padding: 8px;
                  `,
            "data-test-subj": "mlAnomalySwimlaneEmbeddableWrapper",
            "data-shared-item": "" // TODO: Remove data-shared-item as part of https://github.com/elastic/kibana/issues/179376
            ,
            "data-render-complete": error ? true : hasRendered,
            ref: wrapperRef,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 355,
              columnNumber: 17
            }
          }, error ? /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
            title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.ml.swimlaneEmbeddable.errorMessage",
              defaultMessage: "Unable to load the data for the swim lane",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 368,
                columnNumber: 25
              }
            }),
            color: "danger",
            iconType: "warning",
            css: {
              width: '100%'
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 366,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react2.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 377,
              columnNumber: 23
            }
          }, error.message)) : /*#__PURE__*/_react2.default.createElement(_swimlane_container.SwimlaneContainer, {
            id: uuid,
            "data-test-subj": `mlSwimLaneEmbeddable_${uuid}`,
            timeBuckets: timeBuckets,
            swimlaneData: swimlaneData,
            swimlaneType: swimlaneType,
            fromPage: fromPage,
            perPage: perPage,
            swimlaneLimit: (0, _swimlane_container.isViewBySwimLaneData)(swimlaneData) ? swimlaneData.cardinality : undefined,
            onResize: size => chartWidth$.next(size),
            selection: selectedCells,
            onCellsSelection: onCellsSelection,
            onPaginationChange: update => {
              if (update.fromPage) {
                api.updatePagination({
                  fromPage: update.fromPage
                });
              }
              if (update.perPage) {
                api.updatePagination({
                  perPage: update.perPage,
                  fromPage: 1
                });
              }
            },
            isLoading: isLoading,
            yAxisWidth: {
              max: _constants.Y_AXIS_LABEL_WIDTH
            },
            noDataWarning: /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
              titleSize: "xxs",
              css: {
                padding: 0
              },
              title: /*#__PURE__*/_react2.default.createElement("h2", {
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 409,
                  columnNumber: 29
                }
              }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.ml.swimlaneEmbeddable.noDataFound",
                defaultMessage: "No anomalies found",
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 410,
                  columnNumber: 31
                }
              })),
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 405,
                columnNumber: 25
              }
            }),
            chartsService: pluginsStartServices.charts,
            onRenderComplete: () => {
              if (!isLoading) {
                setHasRendered(true);
              }
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 380,
              columnNumber: 21
            }
          }))));
        }
      };
    }
  };
  return factory;
};
exports.getAnomalySwimLaneEmbeddableFactory = getAnomalySwimLaneEmbeddableFactory;