"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _storage = require("../../../../../common/types/storage");
var _collapsible_panel = require("../../../components/collapsible_panel/collapsible_panel");
var _collapsible_panel2 = require("../../../components/collapsible_panel");
var _kibana = require("../../../contexts/kibana");
var _table = require("./table");
var _utils = require("./utils");
var _use_refresh = require("../../../routing/use_refresh");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _anomaly_detection_empty_state = require("../../../jobs/jobs_list/components/anomaly_detection_empty_state");
var _overview_page = require("../../overview_page");
var _ml = require("../../../contexts/ml");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/components/anomaly_detection_panel/anomaly_detection_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyDetectionPanel = ({
  anomalyTimelineService,
  setLazyJobCount
}) => {
  const {
    services: {
      charts: chartsService
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const mlManagementLocator = (0, _kibana.useMlManagementLocator)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const refresh = (0, _use_refresh.useRefresh)();
  const [panelsState, setPanelsState] = (0, _mlLocalStorage.useStorage)(_storage.ML_OVERVIEW_PANELS, _overview_page.overviewPanelDefaultState);
  const manageJobsLink = mlManagementLocator === null || mlManagementLocator === void 0 ? void 0 : mlManagementLocator.useUrl({
    sectionId: 'ml',
    appId: 'anomaly_detection'
  });
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [groups, setGroups] = (0, _react.useState)({});
  const [groupsCount, setGroupsCount] = (0, _react.useState)(0);
  const [statsBarData, setStatsBarData] = (0, _react.useState)();
  const [restStatsBarData, setRestStatsBarData] = (0, _react.useState)();
  const [errorMessage, setErrorMessage] = (0, _react.useState)();
  const loadJobs = async () => {
    setIsLoading(true);
    let lazyJobCount = 0;
    try {
      const jobsResult = await mlApi.jobs.jobsSummary([]);
      const jobsSummaryList = jobsResult.map(job => {
        job.latestTimestampSortValue = job.latestTimestampMs || 0;
        if (job.awaitingNodeAssignment) {
          lazyJobCount++;
        }
        return job;
      });
      const {
        groups: jobsGroups,
        count
      } = (0, _utils.getGroupsFromJobs)(jobsSummaryList);
      const stats = (0, _utils.getStatsBarData)(jobsSummaryList, showNodeInfo);
      const statGroups = (0, _lodash.groupBy)(Object.entries(stats).filter(([k, v]) => v.show).map(([k, v]) => v), 'group');
      setIsLoading(false);
      setErrorMessage(undefined);
      setStatsBarData(statGroups[0]);
      setRestStatsBarData(statGroups[1]);
      setGroupsCount(count);
      setGroups(jobsGroups);
      loadOverallSwimLanes(jobsGroups);
      setLazyJobCount(lazyJobCount);
    } catch (e) {
      setErrorMessage(e.message !== undefined ? e.message : JSON.stringify(e));
      setIsLoading(false);
    }
  };
  const loadOverallSwimLanes = async groupsObject => {
    try {
      // Extract non-empty groups first
      const nonEmptyGroups = Object.fromEntries(Object.entries(groupsObject).filter(([groupId, group]) => group.jobs.length > 0).map(([groupId, group]) => {
        return [groupId, anomalyTimelineService.loadOverallData(group.jobs, 300)];
      }));
      const groupsOverallScoreData = (0, _lodash.zipObject)(Object.keys(nonEmptyGroups), await Promise.all(Object.values(nonEmptyGroups)));
      const tempGroups = {
        ...groupsObject
      };
      for (const groupId in tempGroups) {
        if (Object.hasOwn(tempGroups, groupId)) {
          tempGroups[groupId].overallSwimLane = groupsOverallScoreData[groupId];
        }
      }
      setGroups(tempGroups);
    } catch (e) {
      displayErrorToast(e, _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.errorWithFetchingSwimLanesData', {
        defaultMessage: 'An error occurred fetching anomaly results'
      }));
    }
  };
  (0, _react.useEffect)(() => {
    loadJobs();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refresh === null || refresh === void 0 ? void 0 : refresh.timeRange]);
  const errorDisplay = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.errorPromptTitle', {
      defaultMessage: 'An error occurred getting the anomaly detection jobs list.'
    }),
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("pre", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, errorMessage)));
  const noAdJobs = !errorMessage && isLoading === false && typeof errorMessage === 'undefined' && groupsCount === 0;
  return /*#__PURE__*/_react.default.createElement(_collapsible_panel2.CollapsiblePanel, {
    dataTestSubj: 'mlAnomalyDetectionPanel',
    isOpen: panelsState.adJobs,
    onToggle: update => {
      setPanelsState({
        ...panelsState,
        adJobs: update
      });
    },
    header: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.adJobsPanel.header",
      defaultMessage: "Anomaly Detection Jobs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 9
      }
    }),
    headerItems: [...(statsBarData ? [/*#__PURE__*/_react.default.createElement(_collapsible_panel.OverviewStatsBar, {
      inputStats: statsBarData,
      dataTestSub: 'mlOverviewJobStatsBar',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 14
      }
    })] : []), ...(restStatsBarData ? [/*#__PURE__*/_react.default.createElement(_collapsible_panel.OverviewStatsBar, {
      inputStats: restStatsBarData,
      dataTestSub: 'mlOverviewJobStatsBarExtra',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 15
      }
    })] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: manageJobsLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.manageJobsButtonText', {
      defaultMessage: 'Manage jobs'
    }))],
    ariaLabel: _i18n.i18n.translate('xpack.ml.overview.adJobsPanel.ariaLabel', {
      defaultMessage: 'anomaly detection panel'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 5
    }
  }, noAdJobs ? /*#__PURE__*/_react.default.createElement(_anomaly_detection_empty_state.AnomalyDetectionEmptyState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 19
    }
  }) : null, typeof errorMessage !== 'undefined' && errorDisplay, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    className: "mlOverviewPanel__spinner",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 20
    }
  }) : null, isLoading === false && typeof errorMessage === 'undefined' && groupsCount > 0 ? /*#__PURE__*/_react.default.createElement(_table.AnomalyDetectionTable, {
    items: groups,
    chartsService: chartsService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 9
    }
  }) : null);
};
exports.AnomalyDetectionPanel = AnomalyDetectionPanel;