"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _new_job = require("../../../../../../../../../common/constants/new_job");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/split_cards/split_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SplitCards = exports.SplitCards = /*#__PURE__*/(0, _react.memo)(({
  fieldValues,
  splitField,
  children,
  numberOfDetectors,
  jobType,
  animate = false
}) => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const panels = [];
  const isLightTheme = colorMode === _eui.COLOR_MODES_STANDARD.light;
  const splitCardStyle = {
    ...(isLightTheme ? {
      border: euiTheme.border.thin
    } : {}),
    paddingTop: euiTheme.size.xs
  };
  function storePanels(panel, marginBottom) {
    if (panel !== null) {
      if (animate === false) {
        panel.style.marginBottom = `${marginBottom}px`;
      }
      panels.push({
        panel,
        marginBottom
      });
    }
  }
  function getBackPanels() {
    panels.length = 0;
    const fieldValuesCopy = [...fieldValues];
    fieldValuesCopy.shift();
    let margin = 5;
    const sideMargins = fieldValuesCopy.map((f, i) => margin += 10 - i).reverse();
    if (animate === true) {
      setTimeout(() => {
        panels.forEach(p => p.panel.style.marginBottom = `${p.marginBottom}px`);
      }, 100);
    }
    const SPACING = 100;
    const SPLIT_HEIGHT_MULTIPLIER = 1.6;
    return fieldValuesCopy.map((fieldName, i) => {
      const diff = (i + 1) * (SPLIT_HEIGHT_MULTIPLIER * (10 / fieldValuesCopy.length));
      const marginBottom = -SPACING + diff;
      const sideMargin = sideMargins[i];
      const style = {
        height: `${SPACING}px`,
        marginBottom: `-${SPACING}px`,
        marginLeft: `${sideMargin}px`,
        marginRight: `${sideMargin}px`,
        ...(animate ? {
          transition: 'margin 0.5s'
        } : {})
      };
      return /*#__PURE__*/_react.default.createElement("div", {
        key: fieldName,
        ref: ref => storePanels(ref, marginBottom),
        css: style,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        paddingSize: "m",
        css: splitCardStyle,
        "data-test-subj": "mlSplitCard back",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        css: {
          fontWeight: 'bold',
          fontSize: 'small'
        },
        "data-test-subj": "mlSplitCardTitle",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 15
        }
      }, fieldName)));
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlDataSplit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, (fieldValues.length === 0 || numberOfDetectors === 0) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children), fieldValues.length > 0 && numberOfDetectors > 0 && splitField !== null && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, (jobType === _new_job.JOB_TYPE.MULTI_METRIC || jobType === _new_job.JOB_TYPE.GEO) && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      fontSize: 'small'
    },
    "data-test-subj": `mlDataSplitTitle ${splitField.name}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.splitCards.dataSplitBy",
    defaultMessage: "Data split by {field}",
    values: {
      field: splitField.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 21
    }
  })), getBackPanels(), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    css: splitCardStyle,
    "data-test-subj": "mlSplitCard front",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      fontWeight: 'bold',
      fontSize: 'small'
    },
    "data-test-subj": "mlSplitCardTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 19
    }
  }, fieldValues[0]), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children))))), splitField !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 32
    }
  }) : null);
});