"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiMetricDetectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _kibana = require("../../../../../../../contexts/kibana");
var _job_creator_context = require("../../../job_creator_context");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _fields_utils = require("../../../../../../../../../common/util/fields_utils");
var _settings = require("../../../charts/common/settings");
var _metric_selector = require("../metric_selector");
var _chart_grid = require("./chart_grid");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/multi_metric_view/metric_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultiMetricDetectors = ({
  setIsValid
}) => {
  const uiSettings = (0, _kibana.useUiSettings)();
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated,
    chartLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const newJobCapsService = (0, _new_job_capabilities_service.useNewJobCapsService)();
  const fields = (0, _react.useMemo)(() => (0, _fields_utils.sortFields)([...newJobCapsService.fields, ...jobCreator.runtimeFields]),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const [aggFieldPairList, setAggFieldPairList] = (0, _react.useState)(jobCreator.aggFieldPairs);
  const [lineChartsData, setLineChartsData] = (0, _react.useState)({});
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [start, setStart] = (0, _react.useState)(jobCreator.start);
  const [end, setEnd] = (0, _react.useState)(jobCreator.end);
  const [bucketSpanMs, setBucketSpanMs] = (0, _react.useState)(jobCreator.bucketSpanMs);
  const [chartSettings, setChartSettings] = (0, _react.useState)(_settings.defaultChartSettings);
  const [splitField, setSplitField] = (0, _react.useState)(jobCreator.splitField);
  const [fieldValues, setFieldValues] = (0, _react.useState)([]);
  const [pageReady, setPageReady] = (0, _react.useState)(false);
  function detectorChangeHandler(selectedOptionsIn) {
    addDetector(selectedOptionsIn);
  }
  function addDetector(selectedOptionsIn) {
    if (selectedOptionsIn !== null && selectedOptionsIn.length) {
      const option = selectedOptionsIn[0];
      if (typeof option !== 'undefined' && (0, _mlIsPopulatedObject.isPopulatedObject)(option, ['agg', 'field'])) {
        const newPair = {
          agg: option.agg,
          field: option.field
        };
        setAggFieldPairList([...aggFieldPairList, newPair]);
        setSelectedOptions([]);
      } else {
        setAggFieldPairList([]);
      }
    }
  }
  function deleteDetector(index) {
    aggFieldPairList.splice(index, 1);
    setAggFieldPairList([...aggFieldPairList]);
  }
  (0, _react.useEffect)(() => {
    setPageReady(true);
  }, []);

  // watch for changes in detector list length
  (0, _react.useEffect)(() => {
    jobCreator.removeAllDetectors();
    aggFieldPairList.forEach(pair => {
      jobCreator.addDetector(pair.agg, pair.field);
    });
    jobCreatorUpdate();
    loadCharts();
    setIsValid(aggFieldPairList.length > 0);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [aggFieldPairList.length]);

  // watch for change in jobCreator
  (0, _react.useEffect)(() => {
    if (jobCreator.start !== start || jobCreator.end !== end) {
      setStart(jobCreator.start);
      setEnd(jobCreator.end);
      loadCharts();
    }
    if (jobCreator.bucketSpanMs !== bucketSpanMs) {
      setBucketSpanMs(jobCreator.bucketSpanMs);
      loadCharts();
    }
    setSplitField(jobCreator.splitField);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);

  // watch for changes in split field.
  // load example field values
  // changes to fieldValues here will trigger the card effect
  (0, _react.useEffect)(() => {
    if (splitField !== null) {
      chartLoader.loadFieldExampleValues(splitField, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options).then(setFieldValues).catch(error => {
        toastNotificationService.displayErrorToast(error);
      });
    } else {
      setFieldValues([]);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [splitField]);

  // watch for changes in the split field values
  // reload the charts
  (0, _react.useEffect)(() => {
    loadCharts();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [fieldValues]);
  async function loadCharts() {
    if (allDataReady()) {
      setLoadingData(true);
      try {
        const cs = (0, _settings.getChartSettings)(uiSettings, jobCreator, chartInterval);
        setChartSettings(cs);
        const resp = await chartLoader.loadLineCharts(jobCreator.start, jobCreator.end, aggFieldPairList, jobCreator.splitField, fieldValues.length > 0 ? fieldValues[0] : null, cs.intervalMs, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options);
        setLineChartsData(resp);
      } catch (error) {
        toastNotificationService.displayErrorToast(error);
        setLineChartsData([]);
      }
      setLoadingData(false);
    }
  }
  function allDataReady() {
    return pageReady && aggFieldPairList.length > 0 && (splitField === null || splitField !== null && fieldValues.length > 0);
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_grid.ChartGrid, {
    aggFieldPairList: aggFieldPairList,
    chartSettings: chartSettings,
    splitField: splitField,
    fieldValues: fieldValues,
    lineChartsData: lineChartsData,
    modelData: [],
    anomalyData: [],
    deleteDetector: deleteDetector,
    jobType: jobCreator.type,
    loading: loadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_metric_selector.MetricSelector, {
    fields: fields,
    detectorChangeHandler: detectorChangeHandler,
    selectedOptions: selectedOptions,
    removeOptions: aggFieldPairList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }));
};
exports.MultiMetricDetectors = MultiMetricDetectors;