"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _outlier_exploration = require("./components/outlier_exploration");
var _regression_exploration = require("./components/regression_exploration");
var _classification_exploration = require("./components/classification_exploration");
var _help_menu = require("../../../components/help_menu");
var _kibana = require("../../../contexts/kibana");
var _page_header = require("../../../components/page_header");
var _analytics_selector = require("../components/analytics_selector");
var _empty_prompt = require("../analytics_management/components/empty_prompt");
var _saved_objects_warning = require("../../../components/saved_objects_warning");
var _job_details_flyout_context = require("../../../jobs/components/job_details_flyout/job_details_flyout_context");
var _analytics_detail_flyout = require("./components/analytics_detail_flyout");
var _page_title = require("../../../components/page_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Page = ({
  jobId,
  analysisType
}) => {
  const [analyticsId, setAnalyticsId] = (0, _react.useState)();
  const [isIdSelectorFlyoutVisible, setIsIdSelectorFlyoutVisible] = (0, _react.useState)(false);
  const [jobsExist, setJobsExist] = (0, _react.useState)(true);
  const [isLoadingJobsExist, setIsLoadingJobsExist] = (0, _react.useState)(false);
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const {
    dataFrameAnalytics: {
      getDataFrameAnalytics
    }
  } = (0, _kibana.useMlApi)();
  const helpLink = docLinks.links.ml.dataFrameAnalytics;
  const jobIdToUse = jobId !== null && jobId !== void 0 ? jobId : analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.job_id;
  const [analysisTypeToUse, setAnalysisTypeToUse] = (0, _react.useState)(analysisType || (analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.analysis_type));
  const [, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const checkJobsExist = async () => {
    setIsLoadingJobsExist(true);
    try {
      const {
        count
      } = await getDataFrameAnalytics(undefined, undefined, 0);
      const hasAnalyticsJobs = count > 0;
      setJobsExist(hasAnalyticsJobs);
      setIsIdSelectorFlyoutVisible(hasAnalyticsJobs && !jobId);
    } catch (e) {
      // Swallow the error and just show the empty table in the analytics id selector
      console.error('Error checking analytics jobs exist', e); // eslint-disable-line no-console
    } finally {
      setIsLoadingJobsExist(false);
    }
  };

  // The inner components of the results page don't have a concept of reloading the full page.
  // Because we might want to refresh though if a user has to fix unsynced saved objects,
  // we achieve this here by unmounting the inner pages first by setting `analysisTypeToUse`
  // to `undefined`. The `useEffect()` below will then check if `analysisTypeToUse` doesn't
  // match the passed in analyis type and will update it once again, the re-mounted
  // page will then again fetch the most recent results.
  const refresh = () => {
    setAnalysisTypeToUse(undefined);
  };
  (0, _react.useEffect)(function checkRefresh() {
    if (analysisTypeToUse !== analysisType || analyticsId !== null && analyticsId !== void 0 && analyticsId.analysis_type) {
      setAnalysisTypeToUse(analysisType || (analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.analysis_type));
    }
  }, [analyticsId, analysisType, analysisTypeToUse]);
  (0, _react.useEffect)(function checkJobs() {
    checkJobsExist();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function updateUrl() {
    if (analyticsId !== undefined) {
      setGlobalState({
        ml: {
          ...(analyticsId.analysis_type ? {
            analysisType: analyticsId.analysis_type
          } : {}),
          ...(analyticsId.job_id ? {
            jobId: analyticsId.job_id
          } : {})
        }
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.job_id, analyticsId === null || analyticsId === void 0 ? void 0 : analyticsId.model_id]);
  const getEmptyState = () => {
    if (isLoadingJobsExist) {
      return null;
    }
    if (jobsExist === false) {
      return /*#__PURE__*/_react.default.createElement(_empty_prompt.AnalyticsEmptyPrompt, {
        showDocsLink: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analyticsMap.noJobSelectedLabel",
        defaultMessage: "No Analytics ID selected",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 15
        }
      })),
      "data-test-subj": "mlNoAnalyticsFound",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_job_details_flyout_context.JobInfoFlyoutsProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_analytics_detail_flyout.AnalyticsDetailFlyout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_analytics_selector.AnalyticsIdSelectorControls, {
    setIsIdSelectorFlyoutVisible: setIsIdSelectorFlyoutVisible,
    selectedId: jobIdToUse,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), isIdSelectorFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_analytics_selector.AnalyticsIdSelector, {
    setAnalyticsId: setAnalyticsId,
    setIsIdSelectorFlyoutVisible: setIsIdSelectorFlyoutVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: jobIdToUse !== undefined ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analyticsExploration.titleWithId",
      defaultMessage: "Explore results for job ID {id}",
      values: {
        id: jobIdToUse
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analyticsExploration.title",
      defaultMessage: "Explore results",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: refresh,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }), jobIdToUse && analysisTypeToUse ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageDataFrameAnalyticsExploration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, analysisTypeToUse === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION && /*#__PURE__*/_react.default.createElement(_outlier_exploration.OutlierExploration, {
    jobId: jobIdToUse,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 15
    }
  }), analysisTypeToUse === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION && /*#__PURE__*/_react.default.createElement(_regression_exploration.RegressionExploration, {
    jobId: jobIdToUse,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }), analysisTypeToUse === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION && /*#__PURE__*/_react.default.createElement(_classification_exploration.ClassificationExploration, {
    jobId: jobIdToUse,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 15
    }
  })) : getEmptyState(), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  })));
};
exports.Page = Page;