"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRocCurveChartVegaLiteSpec = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("../../../../../components/vega_chart/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// There is still an issue with Vega Lite's typings with the strict mode Kibana is using.
// @ts-ignore

const GRAY = (0, _eui.euiPaletteGray)(1)[0];
const BASELINE = 'baseline';
const SIZE = 300;

// returns a custom color range that includes gray for the baseline
function getColorRangeNominal(classificationClasses) {
  const legendItems = [...classificationClasses, BASELINE].sort();
  const baselineIndex = legendItems.indexOf(BASELINE);
  const colorRangeNominal = (0, _eui.euiPaletteColorBlind)({
    rotations: 2
  }).slice(0, classificationClasses.length);
  colorRangeNominal.splice(baselineIndex, 0, GRAY);
  return colorRangeNominal;
}
const getRocCurveChartVegaLiteSpec = (classificationClasses, data, legendTitle, euiTheme) => {
  // we append two rows which make up the data for the diagonal baseline
  data.push({
    tpr: 0,
    fpr: 0,
    threshold: 1,
    class_name: BASELINE
  });
  data.push({
    tpr: 1,
    fpr: 1,
    threshold: 1,
    class_name: BASELINE
  });
  const colorRangeNominal = getColorRangeNominal(classificationClasses);
  return {
    $schema: 'https://vega.github.io/schema/vega-lite/v4.8.1.json',
    background: 'transparent',
    // Left padding of 45px to align the left axis of the chart with the confusion matrix above.
    padding: {
      left: 45,
      top: 0,
      right: 0,
      bottom: 0
    },
    config: {
      legend: {
        orient: 'right',
        labelColor: euiTheme.colors.textSubdued,
        titleColor: euiTheme.colors.textSubdued
      },
      view: {
        continuousHeight: SIZE,
        continuousWidth: SIZE
      }
    },
    data: {
      name: 'roc-curve-data'
    },
    datasets: {
      'roc-curve-data': data
    },
    encoding: {
      color: {
        field: 'class_name',
        type: _common.LEGEND_TYPES.NOMINAL,
        scale: {
          range: colorRangeNominal
        },
        legend: {
          title: legendTitle
        }
      },
      size: {
        value: 2
      },
      strokeDash: {
        condition: {
          test: `(datum.class_name === '${BASELINE}')`,
          value: [5, 5]
        },
        value: [0]
      },
      x: {
        field: 'fpr',
        sort: null,
        title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.rocChartSpec.xAxisTitle', {
          defaultMessage: 'False Positive Rate (FPR)'
        }),
        type: 'quantitative',
        axis: {
          tickColor: GRAY,
          labelColor: euiTheme.colors.textSubdued,
          domainColor: GRAY,
          titleColor: euiTheme.colors.textSubdued
        }
      },
      y: {
        field: 'tpr',
        title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.rocChartSpec.yAxisTitle', {
          defaultMessage: 'True Positive Rate (TPR) (a.k.a Recall)'
        }),
        type: 'quantitative',
        axis: {
          tickColor: GRAY,
          labelColor: euiTheme.colors.textSubdued,
          domainColor: GRAY,
          titleColor: euiTheme.colors.textSubdued
        }
      },
      tooltip: [{
        type: _common.LEGEND_TYPES.NOMINAL,
        field: 'class_name'
      }, {
        type: _common.LEGEND_TYPES.QUANTITATIVE,
        field: 'fpr'
      }, {
        type: _common.LEGEND_TYPES.QUANTITATIVE,
        field: 'tpr'
      }]
    },
    height: SIZE,
    width: SIZE,
    mark: {
      type: 'line',
      strokeCap: 'round',
      strokeJoin: 'round'
    }
  };
};
exports.getRocCurveChartVegaLiteSpec = getRocCurveChartVegaLiteSpec;