"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HyperParameters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _advanced_step_form = require("./advanced_step_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/advanced_step/hyper_parameters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_TREES_LIMIT = 2000;
const HyperParameters = ({
  actions,
  state,
  advancedParamErrors
}) => {
  const {
    setFormState
  } = actions;
  const {
    alpha,
    downsampleFactor,
    eta,
    etaGrowthRatePerTree,
    featureBagFraction,
    gamma,
    lambda,
    maxOptimizationRoundsPerHyperparameter,
    maxTrees,
    softTreeDepthLimit,
    softTreeDepthTolerance
  } = state.form;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.lambdaLabel', {
      defaultMessage: 'Lambda'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.lambdaHelpText', {
      defaultMessage: 'A multiplier of the leaf weights in loss calculations. Must be a nonnegative value.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.LAMBDA] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.LAMBDA],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.LAMBDA] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.lambdaInputAriaLabel', {
      defaultMessage: 'A multiplier of leaf weights in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobFlyoutLambdaInput",
    onChange: e => setFormState({
      lambda: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    value: (0, _advanced_step_form.getNumberValue)(lambda),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxTreesLabel', {
      defaultMessage: 'Max trees'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxTreesText', {
      defaultMessage: 'The maximum number of decision trees in the forest.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.MAX_TREES] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.MAX_TREES],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxTreesInputAriaLabel', {
      defaultMessage: 'The maximum number of decision trees in the forest.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobFlyoutMaxTreesInput",
    onChange: e => setFormState({
      maxTrees: e.target.value === '' ? undefined : +e.target.value
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.MAX_TREES] !== undefined,
    step: 1,
    min: 1,
    max: MAX_TREES_LIMIT,
    value: (0, _advanced_step_form.getNumberValue)(maxTrees),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.gammaLabel', {
      defaultMessage: 'Gamma'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.gammaText', {
      defaultMessage: 'A multiplier of the tree size in loss calcuations. Must be nonnegative value.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.GAMMA] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.GAMMA],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.GAMMA] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.gammaInputAriaLabel', {
      defaultMessage: 'A multiplier of the tree size in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardGammaInput",
    onChange: e => setFormState({
      gamma: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    value: (0, _advanced_step_form.getNumberValue)(gamma),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaLabel', {
      defaultMessage: 'Eta'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaText', {
      defaultMessage: 'The shrinkage applied to the weights. Must be between 0.001 and 1.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.ETA] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.ETA],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.ETA] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaInputAriaLabel', {
      defaultMessage: 'The shrinkage applied to the weights.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardEtaInput",
    onChange: e => setFormState({
      eta: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0.001,
    max: 1,
    value: (0, _advanced_step_form.getNumberValue)(eta),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.featureBagFractionLabel', {
      defaultMessage: 'Feature bag fraction'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.featureBagFractionText', {
      defaultMessage: 'The fraction of features used when selecting a random bag for each candidate split.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.FEATURE_BAG_FRACTION] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.FEATURE_BAG_FRACTION],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.featureBagFractionInputAriaLabel', {
      defaultMessage: 'The fraction of features used when selecting a random bag for each candidate split'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardFeatureBagFractionInput",
    onChange: e => setFormState({
      featureBagFraction: e.target.value === '' ? undefined : +e.target.value
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.FEATURE_BAG_FRACTION] !== undefined,
    step: 0.001,
    max: 1,
    value: (0, _advanced_step_form.getNumberValue)(featureBagFraction),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.alphaLabel', {
      defaultMessage: 'Alpha'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.alphaText', {
      defaultMessage: 'A multiplier of the tree depth in loss calculations. Must be greater than or equal to 0.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.ALPHA] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.ALPHA],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.ALPHA] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.alphaInputAriaLabel', {
      defaultMessage: 'A multiplier of the tree depth in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardAlphaInput",
    onChange: e => setFormState({
      alpha: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    value: (0, _advanced_step_form.getNumberValue)(alpha),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.downsampleFactorLabel', {
      defaultMessage: 'Downsample factor'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.downsampleFactorText', {
      defaultMessage: 'The fraction of data used to compute derivatives of the loss function for tree training. Must be between 0 and 1.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.DOWNSAMPLE_FACTOR] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.DOWNSAMPLE_FACTOR],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.DOWNSAMPLE_FACTOR] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.downsampleFactorInputAriaLabel', {
      defaultMessage: 'The fraction of data used to compute derivatives of the loss function for tree training.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardDownsampleFactorInput",
    onChange: e => setFormState({
      downsampleFactor: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    max: 1,
    value: (0, _advanced_step_form.getNumberValue)(downsampleFactor),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaGrowthRatePerTreeLabel', {
      defaultMessage: 'Eta growth rate per tree'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaGrowthRatePerTreeText', {
      defaultMessage: 'The rate at which eta increases for each new tree that is added to the forest. Must be between 0.5 and 2.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.ETA_GROWTH_RATE_PER_TREE] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.ETA_GROWTH_RATE_PER_TREE],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.ETA_GROWTH_RATE_PER_TREE] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.etaGrowthRatePerTreeInputAriaLabel', {
      defaultMessage: 'The rate at which eta increases for each new tree that is added to the forest.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardEtaGrowthRatePerTreeInput",
    onChange: e => setFormState({
      etaGrowthRatePerTree: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0.5,
    max: 2,
    value: (0, _advanced_step_form.getNumberValue)(etaGrowthRatePerTree),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxOptimizationRoundsPerHyperparameterLabel', {
      defaultMessage: 'Max optimization rounds per hyperparameter'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxOptimizationRoundsPerHyperparameterText', {
      defaultMessage: 'The maximum number of optimization rounds for each undefined hyperparameter.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.maxOptimizationRoundsPerHyperparameterInputAriaLabel', {
      defaultMessage: 'The maximum number of optimization rounds for each undefined hyperparameter. Must be an integer between 0 and 20.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardMaxOptimizationRoundsPerHyperparameterInput",
    onChange: e => setFormState({
      maxOptimizationRoundsPerHyperparameter: e.target.value === '' ? undefined : +e.target.value
    }),
    min: 0,
    max: 20,
    step: 1,
    value: (0, _advanced_step_form.getNumberValue)(maxOptimizationRoundsPerHyperparameter),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthLimitLabel', {
      defaultMessage: 'Soft tree depth limit'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthLimitText', {
      defaultMessage: 'Decision trees that exceed this depth are penalized in loss calculations. Must be greater than or equal to 0. '
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_LIMIT] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_LIMIT],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_LIMIT] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthLimitInputAriaLabel', {
      defaultMessage: 'Decision trees that exceed this depth are penalized in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardSoftTreeDepthLimitInput",
    onChange: e => setFormState({
      softTreeDepthLimit: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    value: (0, _advanced_step_form.getNumberValue)(softTreeDepthLimit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthToleranceLabel', {
      defaultMessage: 'Soft tree depth tolerance'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthToleranceText', {
      defaultMessage: 'Control how quickly the loss increases when tree depths exceed soft limits. The smaller the value, the faster the loss increases. Must be greater than or equal to 0.01. '
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_TOLERANCE] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_TOLERANCE],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.SOFT_TREE_DEPTH_TOLERANCE] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.softTreeDepthToleranceInputAriaLabel', {
      defaultMessage: 'Decision trees that exceed this depth are penalized in loss calculations.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardSoftTreeDepthToleranceInput",
    onChange: e => setFormState({
      softTreeDepthTolerance: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0.01,
    value: (0, _advanced_step_form.getNumberValue)(softTreeDepthTolerance),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 11
    }
  }))));
};
exports.HyperParameters = HyperParameters;