"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidateJobUI = exports.ValidateJob = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlValidators = require("@kbn/ml-validators");
var _messages = require("../../../../common/constants/messages");
var _callout = require("../callout");
var _validation_utils = require("../../../../common/util/validation_utils");
var _toast_notification_service = require("../../services/toast_notification_service");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/validate_job/validate_job_view.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultIconType = 'question';
const getDefaultState = () => ({
  ui: {
    iconType: defaultIconType,
    isLoading: true,
    isModalVisible: false
  },
  data: {
    messages: [],
    success: false
  },
  title: ''
});
const MessageList = ({
  messages,
  idFilterList
}) => {
  const callouts = messages.filter(m => idFilterList.includes(m.id) === false).map((m, i) => /*#__PURE__*/_react.default.createElement(_callout.Callout, (0, _extends2.default)({
    key: `${m.id}_${i}`
  }, m, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 20
    }
  })));

  // there could be no error or success messages due to the
  // idFilterList being applied. so rather than showing nothing,
  // show a message saying all passed
  const allPassedCallout = /*#__PURE__*/_react.default.createElement(_callout.Callout, {
    text: _i18n.i18n.translate('xpack.ml.validateJob.allPassed', {
      defaultMessage: 'All validation checks passed successfully'
    }),
    status: _mlValidators.VALIDATION_STATUS.SUCCESS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 10
    }
  }, callouts.length ? callouts : allPassedCallout);
};
MessageList.propTypes = {
  messages: _propTypes.default.array,
  idFilterList: _propTypes.default.array
};
const LoadingSpinner = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceAround",
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "xl",
  "data-test-subj": "mlValidateJobLoadingSpinner",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 7
  }
})));
const Modal = ({
  close,
  title,
  children
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: close,
    style: {
      width: '800px'
    },
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: close,
    size: "s",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.validateJob.modal.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }))));
};
Modal.propType = {
  close: _propTypes.default.func.isRequired,
  title: _propTypes.default.string
};
class ValidateJobUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "closeModal", () => {
      const newState = getDefaultState();
      newState.ui.iconType = this.state.ui.iconType;
      this.setState(newState);
    });
    (0, _defineProperty2.default)(this, "validate", () => {
      const docLinks = this.props.kibana.services.docLinks;
      const job = this.props.getJobConfig();
      const getDuration = this.props.getDuration;
      const duration = typeof getDuration === 'function' ? getDuration() : undefined;
      const fields = this.props.fields;

      // Run job validation only if a job config has been passed on and the duration makes sense to run it.
      // Otherwise we skip the call and display a generic warning, but let the user move on to the next wizard step.
      if (typeof job === 'object') {
        if (typeof duration === 'object' && duration.start !== null && duration.end !== null) {
          let shouldShowLoadingIndicator = true;
          this.props.kibana.services.mlServices.mlApi.validateJob({
            duration,
            fields,
            job
          }).then(validationMessages => {
            const messages = (0, _messages.parseMessages)(validationMessages, docLinks);
            shouldShowLoadingIndicator = false;
            const messagesContainError = messages.some(m => m.status === _mlValidators.VALIDATION_STATUS.ERROR);
            if (messagesContainError) {
              messages.push({
                id: 'job_validation_includes_error',
                text: _i18n.i18n.translate('xpack.ml.validateJob.jobValidationIncludesErrorText', {
                  defaultMessage: 'Job validation has failed, but you can still continue and create the job. Please be aware the job may encounter problems when running.'
                }),
                status: _mlValidators.VALIDATION_STATUS.WARNING
              });
            }
            this.setState({
              ...this.state,
              ui: {
                ...this.state.ui,
                iconType: (0, _callout.statusToEuiIconType)((0, _validation_utils.getMostSevereMessageStatus)(messages)),
                isLoading: false,
                isModalVisible: true
              },
              data: {
                messages,
                success: true
              },
              title: job.job_id
            });
            if (typeof this.props.setIsValid === 'function') {
              // we show a warning that the user can proceed at their own risk
              // therefore return true so the wizard can enable the Next button
              this.props.setIsValid(true);
            }
          }).catch(error => {
            const {
              toasts
            } = this.props.kibana.services.notifications;
            const toastNotificationService = (0, _toast_notification_service.toastNotificationServiceProvider)(toasts);
            toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobService.validateJobErrorTitle', {
              defaultMessage: 'Job Validation Error'
            }));
          });

          // wait for 250ms before triggering the loading indicator
          // to avoid flickering when there's a loading time below
          // 250ms for the job validation data
          const delay = 250;
          setTimeout(() => {
            if (shouldShowLoadingIndicator) {
              this.setState({
                ...this.state,
                ui: {
                  ...this.state.ui,
                  isLoading: true,
                  isModalVisible: false
                }
              });
            }
          }, delay);
        } else {
          this.setState({
            ...this.state,
            ui: {
              ...this.state.ui,
              iconType: (0, _callout.statusToEuiIconType)(_mlValidators.VALIDATION_STATUS.WARNING),
              isLoading: false,
              isModalVisible: true
            },
            data: {
              messages: [{
                id: 'job_validation_skipped',
                text: _i18n.i18n.translate('xpack.ml.validateJob.jobValidationSkippedText', {
                  defaultMessage: 'Job validation could not be run because of insufficient sample data. Please be aware the job may encounter problems when running.'
                }),
                status: _mlValidators.VALIDATION_STATUS.WARNING
              }],
              success: true
            },
            title: job.job_id
          });
          if (typeof this.props.setIsValid === 'function') {
            this.props.setIsValid(true);
          }
        }
      }
    });
    this.state = getDefaultState();
  }
  componentDidMount() {
    if (this.props.embedded === true) {
      this.validate();
    }
  }
  render() {
    const jobTipsUrl = this.props.kibana.services.docLinks.links.ml.anomalyDetectionJobTips;
    // only set to false if really false and not another falsy value, so it defaults to true.
    const fill = this.props.fill === false ? false : true;
    // default to false if not explicitly set to true
    const isCurrentJobConfig = this.props.isCurrentJobConfig !== true ? false : true;
    const isDisabled = this.props.isDisabled !== true ? false : true;
    const embedded = this.props.embedded === true;
    const idFilterList = this.props.idFilterList || [];
    const isLoading = this.state.ui.isLoading;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 7
      }
    }, embedded === false ? /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "mlValidateJobButton",
      onClick: e => this.validate(e),
      size: "s",
      fill: fill,
      iconType: isCurrentJobConfig ? this.state.ui.iconType : defaultIconType,
      iconSide: "right",
      isDisabled: isDisabled,
      isLoading: isLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.validateJob.validateJobButtonLabel",
      defaultMessage: "Validate Job",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 15
      }
    })), !isDisabled && this.state.ui.isModalVisible && /*#__PURE__*/_react.default.createElement(Modal, {
      "data-test-subj": "mlValidateJobModal",
      close: this.closeModal,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.validateJob.modal.validateJobTitle",
        defaultMessage: "Validate job {title}",
        values: {
          title: this.state.title
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 19
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 15
      }
    }, isLoading ? /*#__PURE__*/_react.default.createElement(LoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 19
      }
    }) : /*#__PURE__*/_react.default.createElement(MessageList, {
      messages: this.state.data.messages,
      idFilterList: idFilterList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.validateJob.modal.jobValidationDescriptionText",
      defaultMessage: "Job validation performs certain checks against job configurations and underlying source data and provides specific advice on how to adjust settings that are more likely to produce insightful results.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.validateJob.modal.linkToJobTipsText",
      defaultMessage: "For more information, see {mlJobTipsLink}.",
      values: {
        mlJobTipsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: jobTipsUrl,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 299,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.validateJob.modal.linkToJobTipsText.mlJobTipsLinkText",
          defaultMessage: "Machine Learning Job Tips",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 300,
            columnNumber: 27
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 19
      }
    })))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 11
      }
    }, isLoading ? /*#__PURE__*/_react.default.createElement(LoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(MessageList, {
      messages: this.state.data.messages,
      idFilterList: idFilterList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 15
      }
    })));
  }
}
exports.ValidateJobUI = ValidateJobUI;
ValidateJobUI.propTypes = {
  fields: _propTypes.default.object,
  fill: _propTypes.default.bool,
  getDuration: _propTypes.default.func,
  getJobConfig: _propTypes.default.func.isRequired,
  isCurrentJobConfig: _propTypes.default.bool,
  isDisabled: _propTypes.default.bool,
  embedded: _propTypes.default.bool,
  setIsValid: _propTypes.default.func,
  idFilterList: _propTypes.default.array
};
const ValidateJob = exports.ValidateJob = (0, _public.withKibana)(ValidateJobUI);