"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTableFlyout = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _alerts_table_context = require("@kbn/response-ops-alerts-table/contexts/alerts_table_context");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _translations = require("@kbn/response-ops-alerts-table/translations");
var _render_cell_value = require("./render_cell_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/anomaly_detection_alerts_table/alerts_table_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsTableFlyout = ({
  pageSize,
  pageIndex,
  expandedAlertIndex,
  onExpandedAlertIndexChange,
  alerts,
  alertsCount,
  isLoading,
  columns
}) => {
  var _alert$ALERT_RULE_NAM;
  const {
    services: {
      fieldFormats
    }
  } = (0, _alerts_table_context.useAlertsTableContext)();
  const formatter = (0, _render_cell_value.getAlertFormatters)(fieldFormats);
  const alertIndexInPage = expandedAlertIndex - pageIndex * pageSize;
  if (alertIndexInPage < 0 || alertIndexInPage >= alerts.length || pageSize <= 0) {
    onExpandedAlertIndexChange(null);
    return null;
  }
  const expandedAlertPage = Math.floor(expandedAlertIndex / pageSize);
  // This can be undefined when a new page of alerts is still loading
  const alert = alerts[alertIndexInPage];
  const alertFlyoutAriaLabel = alert && alert[_ruleDataUtils.ALERT_RULE_CATEGORY] ? (0, _translations.getAlertFlyoutAriaLabel)(String(alert[_ruleDataUtils.ALERT_RULE_CATEGORY])) : _translations.ALERT_FLYOUT_DEFAULT_TITLE;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => {
      onExpandedAlertIndexChange === null || onExpandedAlertIndexChange === void 0 ? void 0 : onExpandedAlertIndexChange(null);
    },
    size: "m",
    "data-test-subj": "alertFlyout",
    "aria-label": alertFlyoutAriaLabel,
    ownFocus: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, !isLoading && alert ? (_alert$ALERT_RULE_NAM = alert[_ruleDataUtils.ALERT_RULE_NAME]) === null || _alert$ALERT_RULE_NAM === void 0 ? void 0 : _alert$ALERT_RULE_NAM[0] : _translations.ALERT_FLYOUT_DEFAULT_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _translations.ALERT_FLYOUT_PAGINATION_ARIA_LABEL,
    pageCount: alertsCount,
    activePage: expandedAlertIndex,
    onPageClick: activePage => {
      onExpandedAlertIndexChange === null || onExpandedAlertIndexChange === void 0 ? void 0 : onExpandedAlertIndexChange(activePage);
    },
    compressed: true,
    "data-test-subj": "alertFlyoutPagination",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  })))), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }))) : alert && expandedAlertPage === pageIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: columns.map(column => {
      const alertFieldValue = (0, _lodash.get)(alert, column.id);
      const value = Array.isArray(alertFieldValue) ? alertFieldValue.at(-1) : alertFieldValue;
      return {
        title: column.displayAsText,
        description: (0, _mlIsDefined.isDefined)(value) ? formatter(column.id, value) : '—'
      };
    }),
    type: "column",
    columnWidths: [1, 3] // Same as [25, 75]
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  })));
};
exports.AlertsTableFlyout = AlertsTableFlyout;