"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inject = inject;
var _references = require("../../common/migrations/references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function inject(state, references) {
  // by-reference embeddable
  if (!state.attributes) {
    return state;
  }

  // by-value embeddable
  try {
    // run state through extract logic to ensure any state with hard coded ids is replace with refNames
    // refName generation will produce consistent values allowing inject logic to then replace refNames with current ids.
    const attributesWithNoHardCodedIds = (0, _references.extractReferences)({
      attributes: state.attributes
    }).attributes;
    const {
      attributes: attributesWithInjectedIds
    } = (0, _references.injectReferences)({
      attributes: attributesWithNoHardCodedIds,
      references
    });
    return {
      ...state,
      attributes: attributesWithInjectedIds
    };
  } catch (error) {
    // inject exception prevents entire dashboard from display
    // Instead of throwing, swallow error and let dashboard display
    // Errors will surface in map panel. Any layer that failed injection will surface the error in the legend
    // Users can then manually edit map to resolve any problems.
    return state;
  }
}