"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopNavConfig = getTopNavConfig;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-plugin/public");
var _public2 = require("@kbn/presentation-util-plugin/public");
var _kibana_services = require("../../kibana_services");
var _constants = require("../../../common/constants");
var _content_management = require("../../content_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/routes/map_page/top_nav_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SavedObjectSaveModalDashboardWithSaveResult = (0, _public2.withSuspense)(_public2.LazySavedObjectSaveModalDashboardWithSaveResult);
function getTopNavConfig({
  savedMap,
  isOpenSettingsDisabled,
  isSaveDisabled,
  enableFullScreen,
  openMapSettings,
  inspectorAdapters,
  history
}) {
  const topNavConfigs = [];
  topNavConfigs.push({
    id: 'mapSettings',
    label: _i18n.i18n.translate('xpack.maps.topNav.openSettingsButtonLabel', {
      defaultMessage: `Settings`
    }),
    description: _i18n.i18n.translate('xpack.maps.topNav.openSettingsDescription', {
      defaultMessage: `Open map settings`
    }),
    testId: 'openSettingsButton',
    disableButton() {
      return isOpenSettingsDisabled;
    },
    run() {
      openMapSettings();
    }
  }, {
    id: 'inspect',
    label: _i18n.i18n.translate('xpack.maps.topNav.openInspectorButtonLabel', {
      defaultMessage: `inspect`
    }),
    description: _i18n.i18n.translate('xpack.maps.topNav.openInspectorDescription', {
      defaultMessage: `Open Inspector`
    }),
    testId: 'openInspectorButton',
    run() {
      (0, _kibana_services.getInspector)().open(inspectorAdapters, {});
    }
  }, {
    id: 'full-screen',
    label: _i18n.i18n.translate('xpack.maps.topNav.fullScreenButtonLabel', {
      defaultMessage: `full screen`
    }),
    description: _i18n.i18n.translate('xpack.maps.topNav.fullScreenDescription', {
      defaultMessage: `full screen`
    }),
    testId: 'mapsFullScreenMode',
    run() {
      enableFullScreen();
    }
  });
  if (savedMap.hasOriginatingApp()) {
    topNavConfigs.push({
      label: _i18n.i18n.translate('xpack.maps.topNav.cancel', {
        defaultMessage: 'Cancel'
      }),
      run: () => {
        (0, _kibana_services.getNavigateToApp)()(savedMap.getOriginatingApp(), {
          path: savedMap.getOriginatingPath()
        });
      },
      testId: 'mapsCancelButton',
      description: _i18n.i18n.translate('xpack.maps.topNav.cancelButtonAriaLabel', {
        defaultMessage: 'Return to the last app without saving changes'
      })
    });
  }
  if ((0, _kibana_services.getMapsCapabilities)().save) {
    const hasSaveAndReturnConfig = savedMap.hasSaveAndReturnConfig();
    const mapDescription = savedMap.getAttributes().description ? savedMap.getAttributes().description : '';
    const saveAndReturnButtonLabel = savedMap.isByValue() ? _i18n.i18n.translate('xpack.maps.topNav.saveToMapsButtonLabel', {
      defaultMessage: 'Save to maps'
    }) : _i18n.i18n.translate('xpack.maps.topNav.saveAsButtonLabel', {
      defaultMessage: 'Save as'
    });
    topNavConfigs.push({
      id: 'save',
      iconType: hasSaveAndReturnConfig ? undefined : 'save',
      label: hasSaveAndReturnConfig ? saveAndReturnButtonLabel : _i18n.i18n.translate('xpack.maps.topNav.saveMapButtonLabel', {
        defaultMessage: `save`
      }),
      description: _i18n.i18n.translate('xpack.maps.topNav.saveMapDescription', {
        defaultMessage: `Save map`
      }),
      emphasize: !hasSaveAndReturnConfig,
      testId: 'mapSaveButton',
      disableButton() {
        return isSaveDisabled;
      },
      tooltip() {
        if (isSaveDisabled) {
          return _i18n.i18n.translate('xpack.maps.topNav.saveMapDisabledButtonTooltip', {
            defaultMessage: 'Confirm or Cancel your layer changes before saving'
          });
        }
      },
      run: () => {
        let tags = savedMap.getTags();
        function onTagsSelected(nextTags) {
          tags = nextTags;
        }
        const savedObjectsTagging = (0, _kibana_services.getSavedObjectsTagging)();
        const tagSelector = savedObjectsTagging ? /*#__PURE__*/_react.default.createElement(savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector, {
          initialSelection: tags,
          onTagsSelected: onTagsSelected,
          markOptional: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 162,
            columnNumber: 11
          }
        }) : undefined;
        const saveModalProps = {
          onSave: async props => {
            try {
              await (0, _content_management.checkForDuplicateTitle)({
                id: props.newCopyOnSave ? undefined : savedMap.getSavedObjectId(),
                title: props.newTitle,
                copyOnSave: props.newCopyOnSave,
                lastSavedTitle: savedMap.getSavedObjectId() ? savedMap.getTitle() : '',
                isTitleDuplicateConfirmed: props.isTitleDuplicateConfirmed,
                getDisplayName: () => _constants.MAP_EMBEDDABLE_NAME,
                onTitleDuplicate: props.onTitleDuplicate
              }, {
                overlays: (0, _kibana_services.getCoreOverlays)()
              });
            } catch (e) {
              // ignore duplicate title failure, user notified in save modal
              return {};
            }
            await savedMap.save({
              ...props,
              tags,
              saveByReference: props.addToLibrary,
              history
            });
            // showSaveModal wrapper requires onSave to return an object with an id to close the modal after successful save
            return {
              id: 'id'
            };
          },
          onClose: () => {},
          documentInfo: {
            description: mapDescription,
            id: savedMap.getSavedObjectId(),
            title: savedMap.getTitle()
          },
          objectType: _i18n.i18n.translate('xpack.maps.topNav.saveModalType', {
            defaultMessage: 'map'
          })
        };
        let saveModal;
        if (savedMap.hasOriginatingApp()) {
          saveModal = /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModalOrigin, (0, _extends2.default)({}, saveModalProps, {
            onSave: async props => {
              return saveModalProps.onSave({
                ...props,
                addToLibrary: true
              });
            },
            originatingApp: savedMap.getOriginatingApp(),
            getAppNameFromId: savedMap.getAppNameFromId,
            returnToOriginSwitchLabel: savedMap.isByValue() ? _i18n.i18n.translate('xpack.maps.topNav.updatePanel', {
              defaultMessage: 'Update panel on {originatingAppName}',
              values: {
                originatingAppName: savedMap.getOriginatingAppName()
              }
            }) : undefined,
            options: tagSelector,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 220,
              columnNumber: 13
            }
          }));
        } else {
          saveModal = /*#__PURE__*/_react.default.createElement(SavedObjectSaveModalDashboardWithSaveResult, (0, _extends2.default)({}, saveModalProps, {
            canSaveByReference: true // we know here that we have save capabilities.
            ,
            mustCopyOnSaveMessage: savedMap.isManaged() ? _i18n.i18n.translate('xpack.maps.topNav.mustCopyOnSaveMessage', {
              defaultMessage: 'Elastic manages this map. Save any changes to a new map.'
            }) : undefined,
            tagOptions: tagSelector,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 240,
              columnNumber: 13
            }
          }));
        }
        (0, _public.showSaveModal)(saveModal);
      }
    });
    if (hasSaveAndReturnConfig) {
      topNavConfigs.push({
        id: 'saveAndReturn',
        label: _i18n.i18n.translate('xpack.maps.topNav.saveAndReturnButtonLabel', {
          defaultMessage: 'Save and return'
        }),
        emphasize: true,
        iconType: 'checkInCircleFilled',
        run: () => {
          savedMap.save({
            newTitle: savedMap.getTitle(),
            newDescription: mapDescription,
            newCopyOnSave: false,
            isTitleDuplicateConfirmed: false,
            returnToOrigin: true,
            onTitleDuplicate: () => {},
            saveByReference: !savedMap.isByValue(),
            history
          });
        },
        testId: 'mapSaveAndReturnButton'
      });
    }
  }
  return topNavConfigs;
}