"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/tooltip_control/features_tooltip/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALL_LAYERS = '_ALL_LAYERS_';
const DEFAULT_PAGE_NUMBER = 0;
class Footer extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_prevFeatures", null);
    (0, _defineProperty2.default)(this, "state", {
      filteredFeatures: this.props.features,
      pageNumber: DEFAULT_PAGE_NUMBER,
      selectedLayerId: ALL_LAYERS,
      layerOptions: []
    });
    (0, _defineProperty2.default)(this, "_loadUniqueLayers", async () => {
      if (this._prevFeatures === this.props.features) {
        return;
      }
      this._prevFeatures = this.props.features;
      const countByLayerId = new Map();
      for (let i = 0; i < this.props.features.length; i++) {
        let count = countByLayerId.get(this.props.features[i].layerId);
        if (!count) {
          count = 0;
        }
        count++;
        countByLayerId.set(this.props.features[i].layerId, count);
      }
      const layers = [];
      countByLayerId.forEach((count, layerId) => {
        const layer = this.props.findLayerById(layerId);
        if (layer) {
          layers.push(layer);
        }
      });
      const layerNamePromises = layers.map(layer => {
        return layer.getDisplayName();
      });
      const layerNames = await Promise.all(layerNamePromises);
      if (this._isMounted) {
        this.setState({
          filteredFeatures: this.props.features,
          selectedLayerId: ALL_LAYERS,
          layerOptions: layers.map((layer, index) => {
            const displayName = layerNames[index];
            const count = countByLayerId.get(layer.getId());
            return {
              value: layer.getId(),
              text: `(${count}) ${displayName}`
            };
          })
        }, () => this._onPageChange(DEFAULT_PAGE_NUMBER));
      }
    });
    (0, _defineProperty2.default)(this, "_onPageChange", pageNumber => {
      this.setState({
        pageNumber
      });
      this.props.setCurrentFeature(this.state.filteredFeatures[pageNumber]);
    });
    (0, _defineProperty2.default)(this, "_onLayerChange", e => {
      const newLayerId = e.target.value;
      if (this.state.selectedLayerId === newLayerId) {
        return;
      }
      const filteredFeatures = newLayerId === ALL_LAYERS ? this.props.features : this.props.features.filter(feature => {
        return feature.layerId === newLayerId;
      });
      this.setState({
        filteredFeatures,
        selectedLayerId: newLayerId
      }, () => this._onPageChange(DEFAULT_PAGE_NUMBER));
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadUniqueLayers();
  }
  componentDidUpdate() {
    this._loadUniqueLayers();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    const {
      isLocked
    } = this.props;
    const {
      filteredFeatures,
      pageNumber,
      selectedLayerId,
      layerOptions
    } = this.state;
    const isLayerSelectVisible = isLocked && layerOptions.length > 1;
    const items = [];

    // Pagination controls
    if (isLocked && filteredFeatures.length > 1) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: "pagination",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
        pageCount: filteredFeatures.length,
        activePage: pageNumber,
        onPageClick: this._onPageChange,
        compressed: true,
        "aria-label": _i18n.i18n.translate('xpack.maps.tooltip.paginationLabel', {
          defaultMessage: 'Tooltip results pagination'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 11
        }
      })));
    }

    // Page number readout
    if (!isLocked && filteredFeatures.length > 1) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: !isLayerSelectVisible,
        key: "pageNumber",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.tooltip.pageNumerText",
        defaultMessage: "{pageNumber} of {total}",
        values: {
          pageNumber: pageNumber + 1,
          total: filteredFeatures.length
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 13
        }
      }))));
    }

    // Layer select
    if (isLayerSelectVisible) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: "layerSelect",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "rowCompressed",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        options: [{
          value: ALL_LAYERS,
          text: _i18n.i18n.translate('xpack.maps.tooltip.allLayersLabel', {
            defaultMessage: 'All layers'
          })
        }, ...layerOptions],
        onChange: this._onLayerChange,
        value: selectedLayerId,
        compressed: true,
        fullWidth: true,
        "aria-label": _i18n.i18n.translate('xpack.maps.tooltip.layerFilterLabel', {
          defaultMessage: 'Filter results by layer'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 13
        }
      }))));
    }
    return items.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 9
      }
    }, items)) : null;
  }
}
exports.Footer = Footer;