"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoveLayerConfirmModal = RemoveLayerConfirmModal;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _layer_group = require("../classes/layers/layer_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/remove_layer_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RemoveLayerConfirmModal(props) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  function getChildrenCount(layerGroup) {
    let count = 0;
    layerGroup.getChildren().forEach(childLayer => {
      count++;
      if ((0, _layer_group.isLayerGroup)(childLayer)) {
        count = count + getChildrenCount(childLayer);
      }
    });
    return count;
  }
  function renderMultiLayerWarning() {
    if (!(0, _layer_group.isLayerGroup)(props.layer)) {
      return null;
    }
    const numChildren = getChildrenCount(props.layer);
    return numChildren > 0 ? /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.maps.deleteLayerConfirmModal.multiLayerWarning', {
      defaultMessage: `Removing this layer also removes {numChildren} nested {numChildren, plural, one {layer} other {layers}}.`,
      values: {
        numChildren
      }
    })) : null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.maps.deleteLayerConfirmModal.title', {
      defaultMessage: 'Remove layer?'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: props.onCancel,
    onConfirm: props.onConfirm,
    cancelButtonText: _i18n.i18n.translate('xpack.maps.deleteLayerConfirmModal.cancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.maps.deleteLayerConfirmModal.confirmButtonText', {
      defaultMessage: 'Remove layer'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, renderMultiLayerWarning(), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.maps.deleteLayerConfirmModal.unrecoverableWarning', {
    defaultMessage: `You can't recover removed layers.`
  }))));
}