"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMSFileSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _util = require("../util");
var _ems_unavailable_message = require("./ems_unavailable_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/ems_file_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class EMSFileSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      hasLoadedOptions: false,
      emsFileOptions: []
    });
    (0, _defineProperty2.default)(this, "_loadFileOptions", async () => {
      let fileLayers = [];
      try {
        fileLayers = await (0, _util.getEmsFileLayers)();
      } catch (error) {
        if (this._isMounted) {
          this.setState({
            hasLoadedOptions: true,
            emsFileOptions: []
          });
        }
      }
      const options = fileLayers.map(fileLayer => {
        return {
          value: fileLayer.getId(),
          label: fileLayer.getDisplayName()
        };
      });
      if (this._isMounted) {
        this.setState({
          hasLoadedOptions: true,
          emsFileOptions: options
        });
      }
    });
    (0, _defineProperty2.default)(this, "_onChange", selectedOptions => {
      if (selectedOptions.length === 0) {
        return;
      }
      this.props.onChange(selectedOptions[0].value);
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadFileOptions();
  }
  _renderSelect() {
    if (!this.state.hasLoadedOptions) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        isLoading: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 14
        }
      });
    }
    const selectedOption = this.state.emsFileOptions.find(option => {
      return option.value === this.props.value;
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('xpack.maps.emsFileSelect.selectPlaceholder', {
        defaultMessage: 'Select EMS boundaries'
      }),
      options: this.state.emsFileOptions,
      selectedOptions: selectedOption ? [selectedOption] : [],
      onChange: this._onChange,
      isClearable: false,
      singleSelection: true,
      isDisabled: this.state.emsFileOptions.length === 0,
      "data-test-subj": "emsFileSelect",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.emsFileSelect.selectLabel', {
        defaultMessage: 'EMS boundaries'
      }),
      helpText: this.state.emsFileOptions.length === 0 ? (0, _ems_unavailable_message.getEmsUnavailableMessage)() : null,
      display: this.props.isColumnCompressed ? 'columnCompressed' : 'row',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 7
      }
    }, this._renderSelect());
  }
}
exports.EMSFileSelect = EMSFileSelect;