"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlphaSlider = AlphaSlider;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _validated_range = require("./validated_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/alpha_slider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
function AlphaSlider({
  alpha,
  onChange
}) {
  const onAlphaChange = newAlpha => {
    onChange(newAlpha / 100);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.layerTransparencyLabel', {
      defaultMessage: 'Opacity'
    }),
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
    min: 0,
    max: 100,
    step: 1,
    value: Math.round(alpha * 100),
    onChange: onAlphaChange,
    showInput: true,
    showRange: true,
    compressed: true,
    append: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.percentageLabel', {
      defaultMessage: '%',
      description: 'Percentage'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }));
}