"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OTHER_CATEGORY_KEY = exports.DynamicStyleProperty = void 0;
exports.getNumericalMbFeatureStateValue = getNumericalMbFeatureStateValue;
exports.percentilesValuesToFieldMeta = percentilesValuesToFieldMeta;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _style_property = require("./style_property");
var _vector_style_defaults = require("../vector_style_defaults");
var _constants = require("../../../../../common/constants");
var _data_mapping = require("../components/data_mapping");
var _style_util = require("../style_util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/properties/dynamic_style_property.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OTHER_CATEGORY_KEY = exports.OTHER_CATEGORY_KEY = '__other_bucket__';
class DynamicStyleProperty extends _style_property.AbstractStyleProperty {
  constructor(options, styleName, field, vectorLayer, getFieldFormatter) {
    super(options, styleName);
    (0, _defineProperty2.default)(this, "_field", void 0);
    (0, _defineProperty2.default)(this, "_layer", void 0);
    (0, _defineProperty2.default)(this, "_getFieldFormatter", void 0);
    (0, _defineProperty2.default)(this, "getValueSuggestions", async query => {
      return this._field === null ? [] : await this._field.getSource().getValueSuggestions(this._field, query);
    });
    this._field = field;
    this._layer = vectorLayer;
    this._getFieldFormatter = getFieldFormatter;
  }
  getStyleMetaDataRequest() {
    const dataRequestId = this._getStyleMetaDataRequestId(this.getFieldName());
    return dataRequestId ? this._layer.getDataRequest(dataRequestId) : undefined;
  }
  _getStyleMetaDataRequestId(fieldName) {
    if (this.getFieldOrigin() === _constants.FIELD_ORIGIN.SOURCE) {
      return _constants.SOURCE_META_DATA_REQUEST_ID;
    }
    const join = this._layer.getValidJoins().find(validJoin => {
      return !!validJoin.getRightJoinSource().getFieldByName(fieldName);
    });
    return join ? join.getSourceMetaDataRequestId() : null;
  }
  _getRangeFieldMetaFromLocalFeatures() {
    const style = this._layer.getStyle();
    const styleMeta = style.getStyleMeta();
    const fieldName = this.getFieldName();
    return styleMeta.getRangeFieldMetaDescriptor(fieldName);
  }
  _getRangeFieldMetaFromStyleMetaRequest() {
    const styleMetaDataRequest = this.getStyleMetaDataRequest();
    if (!styleMetaDataRequest || !styleMetaDataRequest.hasData()) {
      return null;
    }
    const data = styleMetaDataRequest.getData();
    const rangeFieldMeta = this._pluckOrdinalStyleMetaFromFieldMetaData(data);
    return rangeFieldMeta ? rangeFieldMeta : null;
  }
  getRangeFieldMeta() {
    const rangeFieldMetaFromLocalFeatures = this._getRangeFieldMetaFromLocalFeatures();
    if (!this.isFieldMetaEnabled()) {
      return rangeFieldMetaFromLocalFeatures;
    }
    const rangeFieldMetaFromServer = this._getRangeFieldMetaFromStyleMetaRequest();
    return rangeFieldMetaFromServer ? rangeFieldMetaFromServer : rangeFieldMetaFromLocalFeatures;
  }
  getPercentilesFieldMeta() {
    if (!this._field) {
      return null;
    }
    const styleMetaDataRequest = this.getStyleMetaDataRequest();
    if (!styleMetaDataRequest || !styleMetaDataRequest.hasData()) {
      return null;
    }
    const styleMetaData = styleMetaDataRequest.getData();
    const percentiles = styleMetaData[`${this._field.getRootName()}_percentiles`];
    return percentilesValuesToFieldMeta(percentiles);
  }
  _getCategoryFieldMetaFromLocalFeatures() {
    const style = this._layer.getStyle();
    const styleMeta = style.getStyleMeta();
    const fieldName = this.getFieldName();
    return styleMeta.getCategoryFieldMetaDescriptor(fieldName);
  }
  _getCategoryFieldMetaFromStyleMetaRequest() {
    const styleMetaDataRequest = this.getStyleMetaDataRequest();
    if (!styleMetaDataRequest || !styleMetaDataRequest.hasData()) {
      return [];
    }
    const data = styleMetaDataRequest.getData();
    return this._pluckCategoricalStyleMetaFromFieldMetaData(data);
  }
  getCategoryFieldMeta() {
    const categoryFieldMetaFromLocalFeatures = this._getCategoryFieldMetaFromLocalFeatures();
    if (!this.isFieldMetaEnabled()) {
      return categoryFieldMetaFromLocalFeatures;
    }
    const categoricalFieldMetaFromServer = this._getCategoryFieldMetaFromStyleMetaRequest();
    return categoricalFieldMetaFromServer.length ? categoricalFieldMetaFromServer : categoryFieldMetaFromLocalFeatures;
  }
  getField() {
    return this._field;
  }
  getFieldName() {
    return this._field ? this._field.getName() : '';
  }
  getMbFieldName() {
    return this._field ? this._field.getMbFieldName() : '';
  }
  isDynamic() {
    return true;
  }
  isOrdinal() {
    return true;
  }
  isCategorical() {
    return false;
  }
  getNumberOfCategories() {
    return 0;
  }
  getStyleMetaHash() {
    const fieldMetaOptions = this.getFieldMetaOptions();
    const parts = [fieldMetaOptions.isEnabled.toString()];
    if (this.isOrdinal()) {
      const dataMappingFunction = this.getDataMappingFunction();
      parts.push(dataMappingFunction);
      if (dataMappingFunction === _constants.DATA_MAPPING_FUNCTION.PERCENTILES && fieldMetaOptions.percentiles) {
        parts.push(fieldMetaOptions.percentiles.join(''));
      }
    } else if (this.isCategorical()) {
      parts.push(this.getNumberOfCategories().toString());
    }
    return parts.join('');
  }
  isComplete() {
    return !!this._field;
  }
  getFieldOrigin() {
    return this._field ? this._field.getOrigin() : null;
  }
  isFieldMetaEnabled() {
    const fieldMetaOptions = this.getFieldMetaOptions();
    return this.supportsFieldMeta() && _lodash.default.get(fieldMetaOptions, 'isEnabled', true);
  }
  supportsFieldMeta() {
    return this.isComplete() && !!this._field && this._field.supportsFieldMetaFromEs();
  }
  async getFieldMetaRequest() {
    if (!this._field) {
      return null;
    }
    if (this.isOrdinal()) {
      var _this$getFieldMetaOpt;
      return this.getDataMappingFunction() === _constants.DATA_MAPPING_FUNCTION.INTERPOLATE ? this._field.getExtendedStatsFieldMetaRequest() : this._field.getPercentilesFieldMetaRequest((_this$getFieldMetaOpt = this.getFieldMetaOptions().percentiles) !== null && _this$getFieldMetaOpt !== void 0 ? _this$getFieldMetaOpt : _constants.DEFAULT_PERCENTILES);
    }
    if (this.isCategorical()) {
      const numberOfCategories = this.getNumberOfCategories();
      return this._field.getCategoricalFieldMetaRequest(numberOfCategories);
    }
    return null;
  }
  supportsFeatureState() {
    return true;
  }
  usesFeatureState() {
    if (!this._field) {
      return false;
    }
    return this._field.getSource().isMvt() ? false : this.supportsFeatureState();
  }
  getMbLookupFunction() {
    return this.usesFeatureState() ? _constants.MB_LOOKUP_FUNCTION.FEATURE_STATE : _constants.MB_LOOKUP_FUNCTION.GET;
  }
  getFieldMetaOptions() {
    const fieldMetaOptions = _lodash.default.get(this.getOptions(), 'fieldMetaOptions', {
      isEnabled: true
    });

    // In 8.0, UI changed to not allow setting isEnabled to false when fieldMeta from local not supported
    // Saved objects created prior to 8.0 may have a configuration where
    // fieldMetaOptions.isEnabled is false and the field does not support fieldMeta from local.
    // In these cases, force isEnabled to true
    // The exact case that spawned this fix is with ES_SEARCH sources and 8.0 where vector tiles switched
    // from vector tiles generated via Kibana server to vector tiles generated via Elasticsearch.
    // Kibana vector tiles supported fieldMeta from local while Elasticsearch vector tiles do not support fieldMeta from local.
    return this._field && !this._field.supportsFieldMetaFromLocalData() ? {
      ...fieldMetaOptions,
      isEnabled: true
    } : fieldMetaOptions;
  }
  getDataMappingFunction() {
    return 'dataMappingFunction' in this._options ? this._options.dataMappingFunction : _constants.DATA_MAPPING_FUNCTION.INTERPOLATE;
  }
  _pluckOrdinalStyleMetaFromFieldMetaData(styleMetaData) {
    if (!this.isOrdinal() || !this._field) {
      return null;
    }
    const stats = styleMetaData[`${this._field.getRootName()}_range`];
    if (!stats || !('avg' in stats)) {
      return null;
    }
    const sigma = _lodash.default.get(this.getFieldMetaOptions(), 'sigma', _vector_style_defaults.DEFAULT_SIGMA);
    const stdLowerBounds = stats.avg - stats.std_deviation * sigma;
    const stdUpperBounds = stats.avg + stats.std_deviation * sigma;
    const min = Math.max(stats.min, stdLowerBounds);
    const max = Math.min(stats.max, stdUpperBounds);
    return {
      min,
      max,
      delta: max - min,
      isMinOutsideStdRange: stats.min < stdLowerBounds,
      isMaxOutsideStdRange: stats.max > stdUpperBounds
    };
  }
  _pluckCategoricalStyleMetaFromFieldMetaData(styleMetaData) {
    if (!this.isCategorical() || !this._field) {
      return [];
    }
    const fieldMeta = styleMetaData[`${this._field.getRootName()}_terms`];
    if (!fieldMeta || !('buckets' in fieldMeta)) {
      return [];
    }
    const categories = fieldMeta.buckets.map(bucket => {
      return {
        key: bucket.key,
        count: bucket.doc_count
      };
    });
    if (fieldMeta.sum_other_doc_count > 0) {
      categories.push({
        key: OTHER_CATEGORY_KEY,
        count: fieldMeta.sum_other_doc_count
      });
    }
    return categories;
  }
  formatField(value) {
    if (this.getField()) {
      const fieldName = this.getFieldName();
      const fieldFormatter = this._getFieldFormatter(fieldName);
      return fieldFormatter ? fieldFormatter(value) : super.formatField(value);
    } else {
      return super.formatField(value);
    }
  }
  _getSupportedDataMappingFunctions() {
    return [_constants.DATA_MAPPING_FUNCTION.INTERPOLATE];
  }
  renderDataMappingPopover(onChange) {
    if (!this._field || !this.supportsFieldMeta()) {
      return null;
    }
    return this.isCategorical() ? /*#__PURE__*/_react.default.createElement(_data_mapping.CategoricalDataMappingPopover, {
      fieldMetaOptions: this.getFieldMetaOptions(),
      onChange: onChange,
      supportsFieldMetaFromLocalData: this._field.supportsFieldMetaFromLocalData(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 416,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_data_mapping.OrdinalDataMappingPopover, {
      fieldMetaOptions: this.getFieldMetaOptions(),
      styleName: this.getStyleName(),
      onChange: onChange,
      dataMappingFunction: this.getDataMappingFunction(),
      supportedDataMappingFunctions: this._getSupportedDataMappingFunctions(),
      supportsFieldMetaFromLocalData: this._field.supportsFieldMetaFromLocalData(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 422,
        columnNumber: 7
      }
    });
  }

  // Returns the name that should be used for accessing the data from the mb-style rule
  // Depending on
  // - whether the field is used for labeling, icon-orientation, or other properties (color, size, ...), `feature-state` and or `get` is used
  // - whether the field was run through a field-formatter, a new dynamic field is created with the formatted-value
  // The combination of both will inform what field-name (e.g. the "raw" field name from the properties, the "computed field-name" for an on-the-fly created property (e.g. for feature-state or field-formatting).
  // todo: There is an existing limitation to .mvt backed sources, where the field-formatters are not applied. Here, the raw-data needs to be accessed.
  getMbPropertyName() {
    if (!this._field) {
      return '';
    }
    let targetName;
    if (this.usesFeatureState()) {
      // Base case for any properties that can support feature-state (e.g. color, size, ...)
      // They just re-use the original property-name
      targetName = this._field.getName();
    } else {
      if (!this._field.getSource().isMvt() && this._field.supportsFieldMetaFromLocalData()) {
        // Geojson-sources can support rewrite
        // e.g. field-formatters will create duplicate field
        targetName = (0, _style_util.getComputedFieldName)(this.getStyleName(), this._field.getName());
      } else {
        // Non-geojson sources (e.g. 3rd party mvt or ES-source as mvt)
        targetName = this._field.getMbFieldName();
      }
    }
    return targetName;
  }
  getMbPropertyValue(rawValue) {
    return this.isOrdinal() ? getNumericalMbFeatureStateValue(rawValue) : rawValue;
  }
  enrichGeoJsonAndMbFeatureState(featureCollection, mbMap, mbSourceId) {
    const usesFeatureState = this.usesFeatureState();
    const featureIdentifier = {
      source: mbSourceId,
      id: undefined
    };
    const featureState = {};
    const targetMbName = this.getMbPropertyName();
    for (let i = 0; i < featureCollection.features.length; i++) {
      const feature = featureCollection.features[i];
      const rawValue = feature.properties ? feature.properties[this.getFieldName()] : undefined;
      const targetMbValue = this.getMbPropertyValue(rawValue);
      if (usesFeatureState) {
        featureState[targetMbName] = targetMbValue; // the same value will be potentially overridden multiple times, if the name remains identical
        featureIdentifier.id = feature.id;
        mbMap.setFeatureState(featureIdentifier, featureState);
      } else {
        if (feature.properties) {
          feature.properties[targetMbName] = targetMbValue;
        }
      }
    }
    return usesFeatureState;
  }
}
exports.DynamicStyleProperty = DynamicStyleProperty;
(0, _defineProperty2.default)(DynamicStyleProperty, "type", _constants.STYLE_TYPE.DYNAMIC);
function getNumericalMbFeatureStateValue(value) {
  if (typeof value !== 'string') {
    return value;
  }
  const valueAsFloat = parseFloat(value);
  return isNaN(valueAsFloat) ? null : valueAsFloat;
}
function percentilesValuesToFieldMeta(percentiles) {
  if (percentiles === undefined || percentiles.values === undefined) {
    return null;
  }
  const percentilesFieldMeta = Object.keys(percentiles.values).map(key => {
    return {
      percentile: key,
      value: percentiles.values[key]
    };
  });
  return _lodash.default.uniqBy(percentilesFieldMeta, 'value');
}