"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StylePropEditor = exports.FIXED_LABEL = exports.BY_VALUE_LABEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_vector_style_label = require("./get_vector_style_label");
var _constants = require("../../../../../common/constants");
var _disabled_tooltip = require("../disabled_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/style_prop_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FIXED_LABEL = exports.FIXED_LABEL = _i18n.i18n.translate('xpack.maps.styles.staticDynamicSelect.staticLabel', {
  defaultMessage: 'Fixed'
});
const BY_VALUE_LABEL = exports.BY_VALUE_LABEL = _i18n.i18n.translate('xpack.maps.styles.staticDynamicSelect.dynamicLabel', {
  defaultMessage: 'By value'
});
class StylePropEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_prevStaticStyleOptions", this.props.defaultStaticStyleOptions);
    (0, _defineProperty2.default)(this, "_prevDynamicStyleOptions", this.props.defaultDynamicStyleOptions);
    (0, _defineProperty2.default)(this, "_onTypeToggle", () => {
      if (this.props.styleProperty.isDynamic()) {
        // preserve current dynmaic style
        this._prevDynamicStyleOptions = this.props.styleProperty.getOptions();
        // toggle to static style
        this.props.onStaticStyleChange(this.props.styleProperty.getStyleName(), this._prevStaticStyleOptions);
      } else {
        // preserve current static style
        this._prevStaticStyleOptions = this.props.styleProperty.getOptions();
        // toggle to dynamic style
        this.props.onDynamicStyleChange(this.props.styleProperty.getStyleName(), this._prevDynamicStyleOptions);
      }
    });
    (0, _defineProperty2.default)(this, "_onDataMappingChange", updatedObjects => {
      const options = {
        ...this.props.styleProperty.getOptions(),
        ...updatedObjects
      };
      this.props.onDynamicStyleChange(this.props.styleProperty.getStyleName(), options);
    });
  }
  renderStaticDynamicSelect() {
    const options = [{
      value: _constants.STYLE_TYPE.STATIC,
      text: this.props.customStaticOptionLabel ? this.props.customStaticOptionLabel : FIXED_LABEL
    }, {
      value: _constants.STYLE_TYPE.DYNAMIC,
      text: BY_VALUE_LABEL
    }];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: options,
      value: this.props.styleProperty.isDynamic() ? _constants.STYLE_TYPE.DYNAMIC : _constants.STYLE_TYPE.STATIC,
      onChange: this._onTypeToggle,
      disabled: this.props.disabled || this.props.fields.length === 0,
      "aria-label": _i18n.i18n.translate('xpack.maps.styles.staticDynamicSelect.ariaLabel', {
        defaultMessage: 'Select to style by fixed value or by data value'
      }),
      compressed: true,
      "data-test-subj": `staticDynamicSelect_${this.props.styleProperty.getStyleName()}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    });
  }
  render() {
    const staticDynamicSelect = this.renderStaticDynamicSelect();
    const stylePropertyForm = this.props.disabled && this.props.disabledBy ? /*#__PURE__*/_react.default.createElement(_disabled_tooltip.DisabledToolTip, {
      content: (0, _get_vector_style_label.getDisabledByMessage)(this.props.disabledBy),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "mapStyleSettings__fixedBox",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 13
      }
    }, staticDynamicSelect), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      compressed: true,
      disabled: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    })))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.cloneElement(this.props.children, {
      staticDynamicSelect
    }), this.props.styleProperty.renderDataMappingPopover(this._onDataMappingChange));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: (0, _get_vector_style_label.getVectorStyleLabel)(this.props.styleProperty.getStyleName()),
      display: "rowCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 7
      }
    }, stylePropertyForm);
  }
}
exports.StylePropEditor = StylePropEditor;