"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrdinalLegend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _ranged_style_legend_row = require("../../../../components/ranged_style_legend_row");
var _constants = require("../../../../../../../common/constants");
var _circle_icon = require("../circle_icon");
var _get_ordinal_label = require("./get_ordinal_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/legend/size/ordinal_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getLineWidthIcons() {
  const defaultStyle = {
    stroke: 'grey',
    fill: 'none',
    width: '12px'
  };
  return [/*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      strokeWidth: '1px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      strokeWidth: '2px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      strokeWidth: '3px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  })];
}
function getSymbolSizeIcons() {
  const defaultStyle = {
    stroke: 'grey',
    fill: 'grey'
  };
  return [/*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      width: '4px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      width: '8px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_circle_icon.CircleIcon, {
    style: {
      ...defaultStyle,
      width: '12px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  })];
}
const EMPTY_VALUE = '';
class OrdinalLegend extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      label: EMPTY_VALUE
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLabel();
  }
  componentDidUpdate() {
    this._loadLabel();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLabel() {
    const field = this.props.style.getField();
    if (!field) {
      return;
    }
    const label = await field.getLabel();
    if (this._isMounted && !_lodash.default.isEqual(this.state.label, label)) {
      this.setState({
        label
      });
    }
  }
  _formatValue(value) {
    if (value === EMPTY_VALUE) {
      return value;
    }
    return this.props.style.formatField(value);
  }
  _renderRangeLegendHeader() {
    let icons;
    if (this.props.style.getStyleName() === _constants.VECTOR_STYLES.LINE_WIDTH) {
      icons = getLineWidthIcons();
    } else if (this.props.style.getStyleName() === _constants.VECTOR_STYLES.ICON_SIZE) {
      icons = getSymbolSizeIcons();
    } else {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    }, icons.map((icon, index) => {
      const isLast = index === icons.length - 1;
      let spacer;
      if (!isLast) {
        spacer = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
          margin: "xs",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 17
          }
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 15
        }
      }, icon), spacer);
    }));
  }
  render() {
    const header = this._renderRangeLegendHeader();
    if (!header) {
      return null;
    }
    const fieldMeta = this.props.style.getRangeFieldMeta();
    let minLabel = EMPTY_VALUE;
    let maxLabel = EMPTY_VALUE;
    if (fieldMeta) {
      const min = this._formatValue(_lodash.default.get(fieldMeta, 'min', EMPTY_VALUE));
      minLabel = (0, _get_ordinal_label.getMinLabel)(this.props.style.isFieldMetaEnabled(), Boolean(fieldMeta.isMinOutsideStdRange), min);
      const max = this._formatValue(_lodash.default.get(fieldMeta, 'max', EMPTY_VALUE));
      maxLabel = (0, _get_ordinal_label.getMaxLabel)(this.props.style.isFieldMetaEnabled(), Boolean(fieldMeta.isMaxOutsideStdRange), max);
    }
    const options = this.props.style.getOptions();
    const invert = options.invert === undefined ? false : options.invert;
    return /*#__PURE__*/_react.default.createElement(_ranged_style_legend_row.RangedStyleLegendRow, {
      header: header,
      minLabel: minLabel,
      maxLabel: maxLabel,
      propertyLabel: this.props.style.getDisplayStyleName(),
      fieldLabel: this.state.label,
      invert: invert,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    });
  }
}
exports.OrdinalLegend = OrdinalLegend;