"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mvtVectorSourceWizardConfig = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _mvt_single_layer_vector_source_editor = require("./mvt_single_layer_vector_source_editor");
var _mvt_single_layer_vector_source = require("./mvt_single_layer_vector_source");
var _vector_layer = require("../../layers/vector_layer");
var _constants = require("../../../../common/constants");
var _vector_tile_layer_icon = require("../../layers/wizards/icons/vector_tile_layer_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/mvt_single_layer_vector_source/layer_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const mvtVectorSourceWizardConfig = exports.mvtVectorSourceWizardConfig = {
  id: _constants.WIZARD_ID.MVT_VECTOR,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.REFERENCE],
  description: _i18n.i18n.translate('xpack.maps.source.mvtVectorSourceWizard', {
    defaultMessage: 'Data service implementing the Mapbox vector tile specification'
  }),
  icon: _vector_tile_layer_icon.VectorTileLayerIcon,
  renderWizard: ({
    previewLayers,
    mapColors
  }) => {
    const onSourceConfigChange = sourceConfig => {
      const sourceDescriptor = _mvt_single_layer_vector_source.MVTSingleLayerVectorSource.createDescriptor(sourceConfig);
      const layerDescriptor = _vector_layer.MvtVectorLayer.createDescriptor({
        sourceDescriptor
      }, mapColors);
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_mvt_single_layer_vector_source_editor.MVTSingleLayerVectorSourceEditor, {
      onSourceConfigChange: onSourceConfigChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 12
      }
    });
  },
  title: _mvt_single_layer_vector_source.sourceTitle
};