"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.heatmapTitle = exports.clustersTitle = exports.ESGeoGridSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-search-plugin/public");
var _mapsVectorTileUtils = require("@kbn/maps-vector-tile-utils");
var _esQuery = require("@kbn/es-query");
var _elasticsearch_util = require("../../../../common/elasticsearch_util");
var _convert_to_geojson = require("./convert_to_geojson");
var _update_source_editor = require("./update_source_editor");
var _constants = require("../../../../common/constants");
var _i18n_getters = require("../../../../common/i18n_getters");
var _es_agg_source = require("../es_agg_source");
var _data_request = require("../../util/data_request");
var _licensed_features = require("../../../licensed_features");
var _kibana_services = require("../../../kibana_services");
var _vector_source = require("../vector_source");
var _valid_string_config = require("../../util/valid_string_config");
var _execution_context_utils = require("../execution_context_utils");
var _is_mvt = require("./is_mvt");
var _vector_style = require("../../styles/vector/vector_style");
var _get_icon_size = require("./get_icon_size");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_geo_grid_source/es_geo_grid_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_GEOTILE_LEVEL = 29;
const clustersTitle = exports.clustersTitle = _i18n.i18n.translate('xpack.maps.source.esGridClustersTitle', {
  defaultMessage: 'Clusters'
});
const heatmapTitle = exports.heatmapTitle = _i18n.i18n.translate('xpack.maps.source.esGridHeatmapTitle', {
  defaultMessage: 'Heat map'
});
class ESGeoGridSource extends _es_agg_source.AbstractESAggSource {
  static createDescriptor(descriptor) {
    const normalizedDescriptor = _es_agg_source.AbstractESAggSource.createDescriptor(descriptor);
    if (!(0, _valid_string_config.isValidStringConfig)(normalizedDescriptor.geoField)) {
      throw new Error('Cannot create an ESGeoGridSourceDescriptor without a geoField');
    }
    return {
      ...normalizedDescriptor,
      type: _constants.SOURCE_TYPES.ES_GEO_GRID,
      geoField: normalizedDescriptor.geoField,
      requestType: descriptor.requestType || _constants.RENDER_AS.POINT,
      resolution: descriptor.resolution ? descriptor.resolution : _constants.GRID_RESOLUTION.COARSE
    };
  }
  constructor(descriptor) {
    const sourceDescriptor = ESGeoGridSource.createDescriptor(descriptor);
    super(sourceDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = sourceDescriptor;
  }
  getBucketsName() {
    if (this._descriptor.requestType === _constants.RENDER_AS.HEX) {
      return _i18n.i18n.translate('xpack.maps.source.esGeoGrid.hex.bucketsName', {
        defaultMessage: 'hexagons'
      });
    }
    if (this._descriptor.requestType === _constants.RENDER_AS.GRID) {
      return _i18n.i18n.translate('xpack.maps.source.esGeoGrid.grid.bucketsName', {
        defaultMessage: 'grid'
      });
    }
    return _i18n.i18n.translate('xpack.maps.source.esGeoGrid.cluster.bucketsName', {
      defaultMessage: 'clusters'
    });
  }
  getGeoFieldName() {
    return this._descriptor.geoField;
  }
  renderSourceSettingsEditor(sourceEditorArgs) {
    async function onChange(...sourceChanges) {
      sourceEditorArgs.onChange(...sourceChanges);
      const resolutionPropChange = sourceChanges.find(sourceChange => {
        return sourceChange.propName === 'resolution';
      });
      if (resolutionPropChange && 'getPropertiesDescriptor' in sourceEditorArgs.style) {
        const propertiesDescriptor = sourceEditorArgs.style.getPropertiesDescriptor();
        if (propertiesDescriptor[_constants.VECTOR_STYLES.ICON_SIZE].type === _constants.STYLE_TYPE.DYNAMIC) {
          propertiesDescriptor[_constants.VECTOR_STYLES.ICON_SIZE] = {
            ...propertiesDescriptor[_constants.VECTOR_STYLES.ICON_SIZE],
            options: {
              ...propertiesDescriptor[_constants.VECTOR_STYLES.ICON_SIZE].options,
              ...(0, _get_icon_size.getIconSize)(resolutionPropChange.value)
            }
          };
          const vectorStyleDescriptor = _vector_style.VectorStyle.createDescriptor(propertiesDescriptor, sourceEditorArgs.style.isTimeAware());
          sourceEditorArgs.onStyleDescriptorChange(vectorStyleDescriptor);
        }
      }
    }
    return /*#__PURE__*/_react.default.createElement(_update_source_editor.UpdateSourceEditor, {
      bucketsName: this.getBucketsName(),
      currentLayerType: sourceEditorArgs.currentLayerType,
      geoFieldName: this.getGeoFieldName(),
      indexPatternId: this.getIndexPatternId(),
      onChange: onChange,
      metrics: this._descriptor.metrics,
      renderAs: this._descriptor.requestType,
      resolution: this._descriptor.resolution,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 7
      }
    });
  }
  getSyncMeta(dataFilters) {
    return {
      ...super.getSyncMeta(dataFilters),
      geogridPrecision: this.getGeoGridPrecision(dataFilters.zoom),
      requestType: this._descriptor.requestType,
      resolution: this._descriptor.resolution
    };
  }
  async getImmutableProperties() {
    return [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: this._descriptor.requestType === _constants.RENDER_AS.HEATMAP ? heatmapTitle : clustersTitle
    }, {
      label: (0, _i18n_getters.getDataViewLabel)(),
      value: await this.getDisplayName()
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.esGrid.geospatialFieldLabel', {
        defaultMessage: 'Cluster field'
      }),
      value: this._descriptor.geoField
    }];
  }
  isMvt() {
    return (0, _is_mvt.isMvt)(this._descriptor.requestType, this._descriptor.resolution);
  }
  isGeoGridPrecisionAware() {
    if (this.isMvt()) {
      // MVT gridded data should not bootstrap each time the precision changes
      // mapbox-gl needs to handle this
      return false;
    } else {
      // Should requery each time grid-precision changes
      return true;
    }
  }
  supportsJoins() {
    return false;
  }
  getGridResolution() {
    return this._descriptor.resolution;
  }
  getGeoGridPrecision(zoom) {
    if (this.isMvt()) {
      // The target-precision needs to be determined server side.
      return 0;
    }
    const targetGeotileLevel = Math.ceil(zoom) + this._getGeoGridPrecisionResolutionDelta();
    return Math.min(targetGeotileLevel, MAX_GEOTILE_LEVEL);
  }
  _getGeoGridPrecisionResolutionDelta() {
    // Hexagon resolutions do not scale evenly to zoom levels.
    // zoomX and zoomX + 1 may result in the same hexagon resolution.
    // To avoid FINE and MOST_FINE providing potenitally the same resolution,
    // use 3 level resolution system that increases zoom + 3 per resolution step.
    if (this._descriptor.requestType === _constants.RENDER_AS.HEX) {
      if (this._descriptor.resolution === _constants.GRID_RESOLUTION.COARSE) {
        return 2;
      }
      if (this._descriptor.resolution === _constants.GRID_RESOLUTION.FINE || this._descriptor.resolution === _constants.GRID_RESOLUTION.MOST_FINE) {
        return 5;
      }
      if (this._descriptor.resolution === _constants.GRID_RESOLUTION.SUPER_FINE) {
        return 8;
      }
    }
    if (this._descriptor.resolution === _constants.GRID_RESOLUTION.COARSE) {
      return 2;
    }
    if (this._descriptor.resolution === _constants.GRID_RESOLUTION.FINE) {
      return 3;
    }
    if (this._descriptor.resolution === _constants.GRID_RESOLUTION.MOST_FINE) {
      return 4;
    }
    if (this._descriptor.resolution === _constants.GRID_RESOLUTION.SUPER_FINE) {
      return 8;
    }
    throw new Error(_i18n.i18n.translate('xpack.maps.source.esGrid.resolutionParamErrorMessage', {
      defaultMessage: `Grid resolution param not recognized: {resolution}`,
      values: {
        resolution: this._descriptor.resolution
      }
    }));
  }
  async _compositeAggRequest({
    searchSource,
    searchSessionId,
    indexPattern,
    precision,
    layerName,
    registerCancelCallback,
    bucketsPerGrid,
    isRequestStillActive,
    bufferedExtent,
    inspectorAdapters,
    executionContext,
    onWarning
  }) {
    const gridsPerRequest = Math.floor(_constants.DEFAULT_MAX_BUCKETS_LIMIT / bucketsPerGrid);
    const aggs = {
      compositeSplit: {
        composite: {
          size: gridsPerRequest,
          sources: [{
            [_constants.GEOTILE_GRID_AGG_NAME]: {
              geotile_grid: {
                bounds: (0, _elasticsearch_util.makeESBbox)(bufferedExtent),
                field: this._descriptor.geoField,
                precision
              }
            }
          }]
        },
        aggs: {
          [_constants.GEOCENTROID_AGG_NAME]: {
            geo_centroid: {
              field: this._descriptor.geoField
            }
          },
          ...this.getValueAggsDsl(indexPattern)
        }
      }
    };
    const features = [];
    let requestCount = 0;
    let afterKey = null;
    while (true) {
      var _esResponse$aggregati;
      if (!isRequestStillActive()) {
        // Stop paging through results if request is obsolete
        throw new _data_request.DataRequestAbortError();
      }
      requestCount++;

      // circuit breaker to ensure reasonable number of requests
      if (requestCount > 5) {
        throw new Error(_i18n.i18n.translate('xpack.maps.source.esGrid.compositePaginationErrorMessage', {
          defaultMessage: `{layerName} is causing too many requests. Reduce "Grid resolution" and/or reduce the number of top term "Metrics".`,
          values: {
            layerName
          }
        }));
      }
      if (afterKey) {
        aggs.compositeSplit.composite.after = afterKey;
      }
      searchSource.setField('aggs', aggs);
      const requestId = afterKey ? `${this.getId()} afterKey ${afterKey.geoSplit}` : this.getId();
      const esResponse = await this._runEsQuery({
        requestId,
        requestName: (0, _vector_source.getLayerFeaturesRequestName)(`${layerName} (${requestCount})`),
        searchSource,
        registerCancelCallback,
        searchSessionId,
        executionContext: (0, _execution_context_utils.mergeExecutionContext)({
          description: 'es_geo_grid_source:cluster_composite'
        }, executionContext),
        requestsAdapter: inspectorAdapters.requests,
        onWarning
      });
      features.push(...(0, _convert_to_geojson.convertCompositeRespToGeoJson)(esResponse, this._descriptor.requestType));
      const aggr = (_esResponse$aggregati = esResponse.aggregations) === null || _esResponse$aggregati === void 0 ? void 0 : _esResponse$aggregati.compositeSplit;
      afterKey = aggr.after_key;
      // @ts-expect-error upgrade typescript v5.1.6
      if (aggr.buckets.length < gridsPerRequest) {
        // Finished because request did not get full resultset back
        break;
      }
    }
    return features;
  }
  async _nonCompositeAggRequest({
    searchSource,
    searchSessionId,
    indexPattern,
    precision,
    layerName,
    registerCancelCallback,
    bufferedExtent,
    tooManyBuckets,
    inspectorAdapters,
    executionContext,
    onWarning
  }) {
    const valueAggsDsl = tooManyBuckets ? this.getValueAggsDsl(indexPattern, metric => {
      // filter out sub-bucket generating metrics if there is the potential for tooManyBucket
      return metric.getBucketCount() === 0;
    }) : this.getValueAggsDsl(indexPattern);
    searchSource.setField('aggs', {
      [_constants.GEOTILE_GRID_AGG_NAME]: {
        geotile_grid: {
          bounds: (0, _elasticsearch_util.makeESBbox)(bufferedExtent),
          field: this._descriptor.geoField,
          precision,
          size: _constants.DEFAULT_MAX_BUCKETS_LIMIT,
          shard_size: _constants.DEFAULT_MAX_BUCKETS_LIMIT
        },
        aggs: {
          [_constants.GEOCENTROID_AGG_NAME]: {
            geo_centroid: {
              field: this._descriptor.geoField
            }
          },
          ...valueAggsDsl
        }
      }
    });
    const esResponse = await this._runEsQuery({
      requestId: this.getId(),
      requestName: (0, _vector_source.getLayerFeaturesRequestName)(layerName),
      searchSource,
      registerCancelCallback,
      searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_geo_grid_source:cluster'
      }, executionContext),
      requestsAdapter: inspectorAdapters.requests,
      onWarning
    });
    return (0, _convert_to_geojson.convertRegularRespToGeoJson)(esResponse, this._descriptor.requestType);
  }
  async _isGeoShape() {
    try {
      const geoField = await this._getGeoField();
      return geoField.type === _constants.ES_GEO_FIELD_TYPE.GEO_SHAPE;
    } catch (error) {
      // ignore _getGeoField exeception, error will surface in legend from loading data.
      return false;
    }
  }
  async getGeoJsonWithMeta(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters) {
    if (!requestMeta.buffer) {
      throw new Error('Cannot get GeoJson without searchFilter.buffer');
    }
    const indexPattern = await this.getIndexPattern();
    const searchSource = await this.makeSearchSource(requestMeta, 0);
    searchSource.setField('trackTotalHits', false);
    let bucketsPerGrid = 1;
    this.getMetricFields().forEach(metricField => {
      bucketsPerGrid += metricField.getBucketCount();
    });

    // Sub-bucketing geotile_grid may result in bucket overflow for higher grid resolutions
    // In those cases, use composite aggregation
    // see https://github.com/elastic/kibana/pull/57875#issuecomment-590515482 for explanation on using separate code paths
    const tooManyBuckets = this._descriptor.resolution !== _constants.GRID_RESOLUTION.COARSE && bucketsPerGrid > 1;

    // geotile_grid with geo_shape does not support composite aggregation
    // https://github.com/elastic/elasticsearch/issues/60626
    const supportsCompositeAgg = !(await this._isGeoShape());
    const precision = this.getGeoGridPrecision(requestMeta.zoom);
    const warnings = [];
    const onWarning = warning => {
      warnings.push(warning);
    };
    const features = supportsCompositeAgg && tooManyBuckets ? await this._compositeAggRequest({
      searchSource,
      searchSessionId: requestMeta.searchSessionId,
      indexPattern,
      precision,
      layerName,
      registerCancelCallback,
      bucketsPerGrid,
      isRequestStillActive,
      bufferedExtent: requestMeta.buffer,
      inspectorAdapters,
      executionContext: requestMeta.executionContext,
      onWarning
    }) : await this._nonCompositeAggRequest({
      searchSource,
      searchSessionId: requestMeta.searchSessionId,
      indexPattern,
      precision,
      layerName,
      registerCancelCallback,
      bufferedExtent: requestMeta.buffer,
      tooManyBuckets,
      inspectorAdapters,
      executionContext: requestMeta.executionContext,
      onWarning
    });
    return {
      data: {
        type: 'FeatureCollection',
        features
      },
      meta: {
        areResultsTrimmed: false,
        warnings
      }
    };
  }
  getTileSourceLayer() {
    return 'aggs';
  }
  async getTileUrl(requestMeta, refreshToken, hasLabels, buffer) {
    const dataView = await this.getIndexPattern();
    const searchSource = await this.makeSearchSource(requestMeta, 0);
    searchSource.setField('aggs', this.getValueAggsDsl(dataView));
    // Filter out documents without geo fields for broad index-pattern support
    searchSource.setField('filter', [...searchSource.getField('filter'), (0, _esQuery.buildExistsFilter)({
      name: this._descriptor.geoField,
      type: 'geo_point'
    }, dataView)]);
    const mvtUrlServicePath = (0, _kibana_services.getHttp)().basePath.prepend(`${_constants.MVT_GETGRIDTILE_API_PATH}/{z}/{x}/{y}.pbf`);
    const tileUrlParams = (0, _mapsVectorTileUtils.getTileUrlParams)({
      geometryFieldName: this._descriptor.geoField,
      index: dataView.getIndexPattern(),
      gridPrecision: this._getGeoGridPrecisionResolutionDelta(),
      hasLabels,
      buffer,
      requestBody: _lodash.default.pick(searchSource.getSearchRequestBody(), ['aggs', 'query', 'runtime_mappings']),
      renderAs: this._descriptor.requestType,
      token: refreshToken,
      executionContextId: (0, _execution_context_utils.getExecutionContextId)(requestMeta.executionContext)
    });
    return `${mvtUrlServicePath}?${tileUrlParams}`;
  }
  isFilterByMapBounds() {
    if (this.isMvt()) {
      // MVT gridded data. Should exclude bounds-filter from ES-DSL
      return false;
    } else {
      // Should include bounds-filter from ES-DSL
      return true;
    }
  }
  hasTooltipProperties() {
    return true;
  }
  async getSupportedShapeTypes() {
    if (this._descriptor.requestType === _constants.RENDER_AS.GRID || this._descriptor.requestType === _constants.RENDER_AS.HEX) {
      return [_constants.VECTOR_SHAPE_TYPE.POLYGON];
    }
    return [_constants.VECTOR_SHAPE_TYPE.POINT];
  }
  async getLicensedFeatures() {
    return (await this._isGeoShape()) ? [_licensed_features.LICENSED_FEATURES.GEO_SHAPE_AGGS_GEO_TILE] : [];
  }
  getFeatureActions({
    addFilters,
    featureId,
    geoFieldNames,
    onClose
  }) {
    if (geoFieldNames.length === 0 || addFilters === null) {
      return [];
    }
    return [{
      label: _i18n.i18n.translate('xpack.maps.tooltip.action.filterByClusterLabel', {
        defaultMessage: 'Filter by cluster'
      }),
      id: 'FILTER_BY_CLUSTER_ACTION',
      onClick: () => {
        const geoGridFilter = (0, _elasticsearch_util.buildGeoGridFilter)({
          geoFieldNames,
          gridId: featureId,
          // featureId is grid id for ES_GEO_GRID source
          isHex: this._descriptor.requestType === _constants.RENDER_AS.HEX
        });
        addFilters([geoGridFilter], _public.ACTION_GLOBAL_APPLY_FILTER);
        onClose();
      }
    }];
  }
}
exports.ESGeoGridSource = ESGeoGridSource;