"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGridCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _utils = require("../../../shared_components/coloring/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/datatable/components/cell_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createGridCell = (formatters, columnConfig, DataContext, isDarkMode, getCellColor, fitRowToContent) => {
  return ({
    rowIndex,
    columnId,
    setCellProps,
    isExpanded
  }) => {
    var _table$rows$rowIndex, _columnConfig$columns;
    const {
      table,
      alignments,
      handleFilterClick
    } = (0, _react.useContext)(DataContext);
    const formatter = formatters[columnId];
    const rawValue = table === null || table === void 0 ? void 0 : (_table$rows$rowIndex = table.rows[rowIndex]) === null || _table$rows$rowIndex === void 0 ? void 0 : _table$rows$rowIndex[columnId];
    const colIndex = columnConfig.columns.findIndex(({
      columnId: id
    }) => id === columnId);
    const {
      oneClickFilter,
      colorMode = 'none',
      palette,
      colorMapping
    } = (_columnConfig$columns = columnConfig.columns[colIndex]) !== null && _columnConfig$columns !== void 0 ? _columnConfig$columns : {};
    const filterOnClick = oneClickFilter && handleFilterClick;
    const content = formatter === null || formatter === void 0 ? void 0 : formatter.convert(rawValue, filterOnClick ? 'text' : 'html');
    const currentAlignment = alignments === null || alignments === void 0 ? void 0 : alignments.get(columnId);
    (0, _react.useEffect)(() => {
      let colorSet = false;
      if (colorMode !== 'none' && (palette || colorMapping)) {
        const color = getCellColor(columnId, palette, colorMapping)(rawValue);
        if (color) {
          const style = {
            [colorMode === 'cell' ? 'backgroundColor' : 'color']: color
          };
          if (colorMode === 'cell' && color) {
            style.color = (0, _utils.getContrastColor)(color, isDarkMode);
          }
          colorSet = true;
          setCellProps({
            style
          });
        }
      }

      // Clean up styles when something changes, this avoids cell's styling to stick forever
      // Checks isExpanded to prevent clearing style after expanding cell
      if (colorSet && !isExpanded) {
        return () => {
          setCellProps({
            style: {
              backgroundColor: undefined,
              color: undefined
            }
          });
        };
      }
    }, [rawValue, columnId, setCellProps, colorMode, palette, colorMapping, isExpanded]);
    if (filterOnClick) {
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "lnsTableCellContent",
        className: (0, _classnames.default)({
          'lnsTableCell--multiline': fitRowToContent,
          [`lnsTableCell--${currentAlignment}`]: true
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => {
          handleFilterClick === null || handleFilterClick === void 0 ? void 0 : handleFilterClick(columnId, rawValue, colIndex, rowIndex);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 11
        }
      }, content));
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      /*
       * dangerouslySetInnerHTML is necessary because the field formatter might produce HTML markup
       * which is produced in a safe way.
       */
      dangerouslySetInnerHTML: {
        __html: content
      } // eslint-disable-line react/no-danger
      ,
      "data-test-subj": "lnsTableCellContent",
      className: (0, _classnames.default)({
        'lnsTableCell--multiline': fitRowToContent,
        'lnsTableCell--colored': colorMode !== 'none',
        [`lnsTableCell--${currentAlignment}`]: true
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    });
  };
};
exports.createGridCell = createGridCell;