"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendSizeSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/visualizations-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/legend/size/legend_size_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const legendSizeOptions = [{
  value: _public.LegendSize.SMALL,
  inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.small', {
    defaultMessage: 'Small'
  })
}, {
  value: _public.LegendSize.MEDIUM,
  inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.medium', {
    defaultMessage: 'Medium'
  })
}, {
  value: _public.LegendSize.LARGE,
  inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.large', {
    defaultMessage: 'Large'
  })
}, {
  value: _public.LegendSize.EXTRA_LARGE,
  inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.extraLarge', {
    defaultMessage: 'Extra large'
  })
}];
const LegendSizeSettings = ({
  legendSize,
  onLegendSizeChange,
  isVerticalLegend,
  showAutoOption
}) => {
  (0, _react.useEffect)(() => {
    if (legendSize && !isVerticalLegend) {
      onLegendSizeChange(undefined);
    }
  }, [isVerticalLegend, legendSize, onLegendSizeChange]);
  const onLegendSizeOptionChange = (0, _react.useCallback)(option => onLegendSizeChange(option === _public.DEFAULT_LEGEND_SIZE ? undefined : option), [onLegendSizeChange]);
  if (!isVerticalLegend) return null;
  const options = showAutoOption ? [{
    value: _public.LegendSize.AUTO,
    inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.auto', {
      defaultMessage: 'Auto'
    })
  }, ...legendSizeOptions] : legendSizeOptions;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.label', {
      defaultMessage: 'Width'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    compressed: true,
    valueOfSelected: legendSize !== null && legendSize !== void 0 ? legendSize : _public.DEFAULT_LEGEND_SIZE,
    options: options,
    onChange: onLegendSizeOptionChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }));
};
exports.LegendSizeSettings = LegendSizeSettings;