"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemoveLayerAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/expression-xy-plugin/public");
var _settings_storage = require("../../../../settings_storage");
var _order_bounds = require("./order_bounds");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/layer_actions/remove_layer_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SKIP_DELETE_MODAL_KEY = 'skipDeleteModal';
const getCopy = (layerType, isOnlyLayer, customModalText = undefined) => {
  var _customModalText$titl, _customModalText$desc, _customModalText$titl2, _customModalText$desc2, _customModalText$titl3, _customModalText$desc3;
  if (isOnlyLayer && layerType === 'data') {
    return {
      buttonLabel: _i18n.i18n.translate('xpack.lens.resetLayerAriaLabel', {
        defaultMessage: 'Clear layer'
      }),
      modalTitle: _i18n.i18n.translate('xpack.lens.modalTitle.title.clearVis', {
        defaultMessage: 'Clear visualization layer?'
      }),
      modalBody: _i18n.i18n.translate('xpack.lens.layer.confirmModal.clearVis', {
        defaultMessage: `Clearing this layer removes the visualization and its configurations. `
      })
    };
  }
  const buttonLabel = _i18n.i18n.translate('xpack.lens.deleteLayerAriaLabel', {
    defaultMessage: `Delete layer`
  });
  switch (layerType) {
    case 'data':
      return {
        buttonLabel,
        modalTitle: (_customModalText$titl = customModalText === null || customModalText === void 0 ? void 0 : customModalText.title) !== null && _customModalText$titl !== void 0 ? _customModalText$titl : _i18n.i18n.translate('xpack.lens.modalTitle.title.deleteVis', {
          defaultMessage: 'Delete visualization layer?'
        }),
        modalBody: (_customModalText$desc = customModalText === null || customModalText === void 0 ? void 0 : customModalText.description) !== null && _customModalText$desc !== void 0 ? _customModalText$desc : _i18n.i18n.translate('xpack.lens.layer.confirmModal.deleteVis', {
          defaultMessage: `Deleting this layer removes the visualization and its configurations. `
        })
      };
    case 'annotations':
      return {
        buttonLabel,
        modalTitle: (_customModalText$titl2 = customModalText === null || customModalText === void 0 ? void 0 : customModalText.title) !== null && _customModalText$titl2 !== void 0 ? _customModalText$titl2 : _i18n.i18n.translate('xpack.lens.modalTitle.title.deleteAnnotations', {
          defaultMessage: 'Delete annotation group?'
        }),
        modalBody: (_customModalText$desc2 = customModalText === null || customModalText === void 0 ? void 0 : customModalText.description) !== null && _customModalText$desc2 !== void 0 ? _customModalText$desc2 : _i18n.i18n.translate('xpack.lens.layer.confirmModal.deleteAnnotation', {
          defaultMessage: `Deleting this layer removes the annotations and their configurations. `
        })
      };
    case 'referenceLine':
      return {
        buttonLabel,
        modalTitle: (_customModalText$titl3 = customModalText === null || customModalText === void 0 ? void 0 : customModalText.title) !== null && _customModalText$titl3 !== void 0 ? _customModalText$titl3 : _i18n.i18n.translate('xpack.lens.modalTitle.title.deleteReferenceLines', {
          defaultMessage: 'Delete reference lines layer?'
        }),
        modalBody: (_customModalText$desc3 = customModalText === null || customModalText === void 0 ? void 0 : customModalText.description) !== null && _customModalText$desc3 !== void 0 ? _customModalText$desc3 : _i18n.i18n.translate('xpack.lens.layer.confirmModal.deleteRefLine', {
          defaultMessage: `Deleting this layer removes the reference lines and their configurations. `
        })
      };
    default:
      throw new Error('Unknown layer type');
  }
};
const RemoveConfirmModal = ({
  modalTitle,
  modalDesc,
  skipDeleteModal,
  isDeletable,
  execute,
  closeModal,
  updateLensLocalStorage
}) => {
  const [skipDeleteModalLocal, setSkipDeleteModalLocal] = (0, _react.useState)(skipDeleteModal);
  const onChangeShouldShowModal = (0, _react.useCallback)(({
    target
  }) => setSkipDeleteModalLocal(target.checked), []);
  const onRemove = (0, _react.useCallback)(() => {
    updateLensLocalStorage({
      [SKIP_DELETE_MODAL_KEY]: skipDeleteModalLocal
    });
    closeModal();
    execute();
  }, [closeModal, execute, skipDeleteModalLocal, updateLensLocalStorage]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, modalTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, modalDesc, _i18n.i18n.translate('xpack.lens.layer.confirmModal.cannotUndo', {
    defaultMessage: `You can't undo this action.`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: 'lnsLayerRemoveModalCheckbox',
    label: _i18n.i18n.translate('xpack.lens.layer.confirmModal.dontAskAgain', {
      defaultMessage: `Don't ask me again`
    }),
    checked: skipDeleteModalLocal,
    onChange: onChangeShouldShowModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.lens.layer.cancelDelete', {
    defaultMessage: `Cancel`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "lnsLayerRemoveConfirmButton",
    onClick: onRemove,
    color: "danger",
    iconType: isDeletable ? 'trash' : 'eraser',
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 17
    }
  }, isDeletable ? _i18n.i18n.translate('xpack.lens.layer.confirmDelete', {
    defaultMessage: `Delete layer`
  }) : _i18n.i18n.translate('xpack.lens.layer.confirmClear', {
    defaultMessage: `Clear layer`
  }))))))));
};
const getRemoveLayerAction = props => {
  const {
    buttonLabel,
    modalTitle,
    modalBody
  } = getCopy(props.layerType || _public2.LayerTypes.DATA, props.isOnlyLayer, props.customModalText);
  return {
    execute: async () => {
      var _storage$get;
      const storage = new _public.Storage(localStorage);
      const lensLocalStorage = (_storage$get = storage.get(_settings_storage.LOCAL_STORAGE_LENS_KEY)) !== null && _storage$get !== void 0 ? _storage$get : {};
      const updateLensLocalStorage = partial => {
        storage.set(_settings_storage.LOCAL_STORAGE_LENS_KEY, {
          ...lensLocalStorage,
          ...partial
        });
      };
      if (!lensLocalStorage.skipDeleteModal) {
        var _lensLocalStorage$LOC;
        const {
          overlays,
          ...startServices
        } = props.core;
        const modal = overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(RemoveConfirmModal, {
          modalTitle: modalTitle,
          isDeletable: !props.isOnlyLayer,
          modalDesc: modalBody,
          skipDeleteModal: (_lensLocalStorage$LOC = lensLocalStorage[_settings_storage.LOCAL_STORAGE_LENS_KEY]) !== null && _lensLocalStorage$LOC !== void 0 ? _lensLocalStorage$LOC : false,
          execute: props.execute,
          closeModal: () => modal.close(),
          updateLensLocalStorage: updateLensLocalStorage,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 229,
            columnNumber: 13
          }
        }), startServices), {
          'data-test-subj': 'lnsLayerRemoveModal',
          maxWidth: 600
        });
        await modal.onClose;
      } else {
        props.execute();
      }
    },
    displayName: buttonLabel,
    isCompatible: true,
    icon: props.isOnlyLayer ? 'eraser' : 'trash',
    color: 'danger',
    'data-test-subj': `lnsLayerRemove--${props.layerIndex}`,
    order: _order_bounds.LAST_ACTION_ORDER
  };
};
exports.getRemoveLayerAction = getRemoveLayerAction;