"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataLossWarning = exports.ChartSwitchOptionPrepend = exports.ChartOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/chart_switch/chart_option.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ChartOption = ({
  option,
  searchValue = ''
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    css: (0, _react2.css)`
        text-align: left;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: option.icon || 'empty',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "lnsChartSwitch-option-label",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, option.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, option.description ? /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 13
    }
  }, option.description) : null)));
};
exports.ChartOption = ChartOption;
const getDataLossWarning = dataLoss => {
  if (dataLoss === 'nothing') {
    return;
  }
  if (dataLoss === 'everything') {
    return _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossEverything', {
      defaultMessage: 'Changing to this visualization clears the current configuration.'
    });
  }
  if (dataLoss === 'layers') {
    return _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossLayersDescription', {
      defaultMessage: 'Changing to this visualization modifies currently selected layer`s configuration and removes all other layers.'
    });
  } else return _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossColumns', {
    defaultMessage: `Changing to this visualization modifies the current configuration.`
  });
};
exports.getDataLossWarning = getDataLossWarning;
const CheckIcon = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    color: euiTheme.colors.darkestShade,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 10
    }
  });
};
const DataLossWarning = ({
  content,
  id
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!content) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "m",
    "aria-label": content,
    type: "dot",
    color: euiTheme.colors.warning,
    content: content,
    iconProps: {
      'data-test-subj': `lnsChartSwitchPopoverAlert_${id}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  });
};
const ChartSwitchOptionPrepend = ({
  isChecked,
  dataLoss,
  subtypeId
}) => {
  const dataLossWarning = getDataLossWarning(dataLoss);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, isChecked && /*#__PURE__*/_react.default.createElement(CheckIcon, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 21
    }
  }), dataLossWarning && /*#__PURE__*/_react.default.createElement(DataLossWarning, {
    content: dataLossWarning,
    id: subtypeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 27
    }
  }), !dataLossWarning && !isChecked && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "empty",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 42
    }
  }));
};
exports.ChartSwitchOptionPrepend = ChartSwitchOptionPrepend;