"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Synopsis = Synopsis;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/kibana_overview/public/components/synopsis/synopsis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function Synopsis({
  id,
  title,
  description,
  iconUrl,
  iconType,
  url,
  isBeta,
  onClick,
  wrapInPanel
}) {
  let optionalImg;
  const classes = (0, _classnames.default)('homSynopsis__card', {
    'homSynopsis__card--noPanel': !wrapInPanel
  });
  const betaBadgeProps = isBeta ? {
    label: 'Beta'
  } : undefined;
  if (iconUrl) {
    optionalImg = /*#__PURE__*/_react.default.createElement("img", {
      alt: "",
      className: "synopsisIcon",
      src: iconUrl,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 19
      }
    });
  } else if (iconType) {
    optionalImg = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "text",
      size: "l",
      title: "",
      type: iconType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 19
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, (0, _extends2.default)({}, betaBadgeProps && {
    betaBadgeProps
  }, {
    className: classes,
    layout: "horizontal",
    icon: optionalImg,
    titleSize: "xs",
    title: title,
    description: description,
    onClick: onClick,
    href: url,
    "data-test-subj": `homeSynopsisLink${id.toLowerCase()}`,
    titleElement: "h3",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }));
}