"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressIndicator = exports.LoadingSteps = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _useTimeoutFn = _interopRequireDefault(require("react-use/lib/useTimeoutFn"));
var _i18n = require("@kbn/i18n");
var _use_kibana = require("./use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/interactive_setup/public/progress_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isKibanaPastPreboot(response, body) {
  var _response$headers$get, _body$status, _body$status$overall;
  if (!(response !== null && response !== void 0 && (_response$headers$get = response.headers.get('content-type')) !== null && _response$headers$get !== void 0 && _response$headers$get.includes('application/json'))) {
    return false;
  }
  return (body === null || body === void 0 ? void 0 : (_body$status = body.status) === null || _body$status === void 0 ? void 0 : (_body$status$overall = _body$status.overall) === null || _body$status$overall === void 0 ? void 0 : _body$status$overall.level) === 'available';
}
const ProgressIndicator = ({
  onSuccess
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)();
  const [status, checkStatus] = (0, _useAsyncFn.default)(async () => {
    let isAvailable = false;
    let isPastPreboot = false;
    try {
      const {
        response,
        body
      } = await http.get('/api/status', {
        asResponse: true
      });
      isAvailable = response ? response.status < 500 : undefined;
      isPastPreboot = isKibanaPastPreboot(response, body);
    } catch (error) {
      const {
        response,
        body = {}
      } = error;
      isAvailable = response ? response.status < 500 : undefined;
      isPastPreboot = isKibanaPastPreboot(response, body);
    }
    return isAvailable === true && isPastPreboot ? 'complete' : isAvailable === false ? 'unavailable' : isAvailable === true && !isPastPreboot ? 'preboot' : 'unknown';
  });
  const [, cancelPolling, resetPolling] = (0, _useTimeoutFn.default)(checkStatus, 1000);
  (0, _react.useEffect)(() => {
    if (status.value === 'complete') {
      cancelPolling();
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
    } else if (status.loading === false) {
      resetPolling();
    }
  }, [status.loading, status.value]); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(LoadingSteps, {
    currentStepId: status.value,
    steps: [{
      id: 'preboot',
      title: _i18n.i18n.translate('interactiveSetup.progressIndicator.prebootStepTitle', {
        defaultMessage: 'Saving settings'
      })
    }, {
      id: 'unavailable',
      title: _i18n.i18n.translate('interactiveSetup.progressIndicator.unavailableStepTitle', {
        defaultMessage: 'Starting Elastic'
      })
    }, {
      id: 'complete',
      title: _i18n.i18n.translate('interactiveSetup.progressIndicator.completeStepTitle', {
        defaultMessage: 'Completing setup'
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
};
exports.ProgressIndicator = ProgressIndicator;
const LoadingSteps = ({
  currentStepId,
  steps
}) => {
  const [stepIndex, setStepIndex] = (0, _react.useState)(0);
  const currentStepIndex = steps.findIndex(step => step.id === currentStepId);

  // Ensure that loading progress doesn't move backwards
  (0, _react.useEffect)(() => {
    if (currentStepIndex > stepIndex) {
      setStepIndex(currentStepIndex);
    }
  }, [currentStepIndex, stepIndex]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps.map((step, i) => ({
      status: i <= stepIndex ? 'complete' : i - 1 === stepIndex ? 'loading' : 'incomplete',
      children: null,
      ...step
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  });
};
exports.LoadingSteps = LoadingSteps;