"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrollmentTokenHelpPopover = exports.EnrollmentTokenForm = void 0;
exports.compareAddresses = compareAddresses;
exports.decodeEnrollmentToken = decodeEnrollmentToken;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_link = require("./doc_link");
var _get_command_line_snippet = require("./get_command_line_snippet");
var _submit_error_callout = require("./submit_error_callout");
var _text_truncate = require("./text_truncate");
var _use_form = require("./use_form");
var _use_kibana = require("./use_kibana");
var _use_verification = require("./use_verification");
var _use_visibility = require("./use_visibility");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/interactive_setup/public/enrollment_token_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnrollmentTokenForm = ({
  defaultValues = {
    token: ''
  },
  onCancel,
  onSuccess
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)();
  const {
    status,
    getCode
  } = (0, _use_verification.useVerification)();
  const [form, eventHandlers] = (0, _use_form.useForm)({
    defaultValues,
    validate: values => {
      const errors = {};
      if (!values.token) {
        errors.token = _i18n.i18n.translate('interactiveSetup.enrollmentTokenForm.tokenRequiredError', {
          defaultMessage: 'Enter an enrollment token.'
        });
      } else {
        const decoded = decodeEnrollmentToken(values.token);
        if (!decoded) {
          errors.token = _i18n.i18n.translate('interactiveSetup.enrollmentTokenForm.tokenInvalidError', {
            defaultMessage: 'Enter a valid enrollment token.'
          });
        }
      }
      return errors;
    },
    onSubmit: async values => {
      const decoded = decodeEnrollmentToken(values.token);
      await http.post('/internal/interactive_setup/enroll', {
        body: JSON.stringify({
          hosts: decoded.adr,
          apiKey: decoded.key,
          caFingerprint: decoded.fgr,
          code: getCode()
        })
      });
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
    }
  });
  const [isVisible, buttonRef] = (0, _use_visibility.useVisibility)();
  (0, _useUpdateEffect.default)(() => {
    if (status === 'verified' && isVisible) {
      form.submit();
    }
  }, [status]);
  const enrollmentToken = decodeEnrollmentToken(form.values.token);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, (0, _extends2.default)({
    component: "form",
    noValidate: true
  }, eventHandlers, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }), status !== 'unverified' && !form.isSubmitting && !form.isValidating && form.submitError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_submit_error_callout.SubmitErrorCallout, {
    error: form.submitError,
    defaultTitle: _i18n.i18n.translate('interactiveSetup.enrollmentTokenForm.submitErrorTitle', {
      defaultMessage: "Couldn't configure Elastic"
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('interactiveSetup.enrollmentTokenForm.tokenLabel', {
      defaultMessage: 'Enrollment token'
    }),
    error: form.errors.token,
    isInvalid: form.touched.token && !!form.errors.token,
    helpText: enrollmentToken ? /*#__PURE__*/_react.default.createElement(EnrollmentTokenDetails, {
      token: enrollmentToken,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(EnrollmentTokenHelpPopover, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    name: "token",
    value: form.values.token,
    isInvalid: form.touched.token && !!form.errors.token,
    placeholder: _i18n.i18n.translate('interactiveSetup.enrollmentTokenForm.tokenPlaceholder', {
      defaultMessage: 'Paste enrollment token from terminal.'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "right",
    iconType: "gear",
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.enrollmentTokenForm.cancelButton",
    defaultMessage: "Configure manually",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    buttonRef: buttonRef,
    type: "submit",
    isLoading: form.isSubmitting,
    isDisabled: form.isSubmitted && form.isInvalid,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.enrollmentTokenForm.submitButton",
    defaultMessage: "{isSubmitting, select, true{Configuring Elastic\u2026} other{Configure Elastic}}",
    values: {
      isSubmitting: form.isSubmitting
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  })))));
};
exports.EnrollmentTokenForm = EnrollmentTokenForm;
const EnrollmentTokenDetails = ({
  token
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 179,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  responsive: false,
  alignItems: "center",
  gutterSize: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 180,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  className: "eui-textNoWrap",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 181,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "interactiveSetup.enrollmentTokenDetails.connectTo",
  defaultMessage: "Connect to",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 182,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  css: {
    overflow: 'hidden'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 187,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_text_truncate.TextTruncate, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 188,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement("strong", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 189,
    columnNumber: 11
  }
}, token.adr[0])))));
function decodeEnrollmentToken(enrollmentToken) {
  try {
    const json = JSON.parse(atob(enrollmentToken));
    if (!Array.isArray(json.adr) || json.adr.some(adr => typeof adr !== 'string') || typeof json.fgr !== 'string' || typeof json.key !== 'string' || typeof json.ver !== 'string') {
      return;
    }
    json.adr.sort(compareAddresses);
    return {
      ...json,
      adr: json.adr.map(host => `https://${host}`),
      key: btoa(json.key)
    };
  } catch (error) {} // eslint-disable-line no-empty
}

/**
 * Compares two Elasticsearch addresses. Sorts IPv4 addresses before IPv6 addresses.
 */
function compareAddresses(a, b) {
  if (a.indexOf('[') === -1 && b.indexOf('[') !== -1) {
    return -1;
  }
  if (a.indexOf('[') !== -1 && b.indexOf('[') === -1) {
    return 1;
  }
  return 0;
}
const EnrollmentTokenHelpPopover = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => setIsPopoverOpen(isOpen => !isOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.enrollmentTokenHelpPopover.buttonText",
    defaultMessage: "Where do I find this?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    anchorPosition: "rightCenter",
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.enrollmentTokenHelpPopover.helpText",
    defaultMessage: "The enrollment token is automatically generated when you start Elasticsearch for the first time. You might need to scroll back a bit in the terminal to view it.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.enrollmentTokenHelpPopover.commandHelpText",
    defaultMessage: "To generate a new enrollment token, run the following command from the Elasticsearch installation directory:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    paddingSize: "m",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  }, (0, _get_command_line_snippet.getCommandLineSnippet)('elasticsearch-create-enrollment-token', '--scope kibana'))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
    app: "elasticsearch",
    doc: "configuring-stack-security.html",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.enrollmentTokenHelpPopover.docLinkText",
    defaultMessage: "Learn how to set up Elastic.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  }))));
};
exports.EnrollmentTokenHelpPopover = EnrollmentTokenHelpPopover;