"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _adapters = require("../../../../common/adapters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/views/requests/components/request_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class RequestSelector extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "handleSelected", selectedOptions => {
      const selectedOption = this.props.requests.find(request => request.id === selectedOptions[0].value);
      if (selectedOption) {
        this.props.onRequestChanged(selectedOption);
      }
    });
  }
  renderRequestCombobox() {
    const options = this.props.requests.map(item => {
      const hasFailed = item.status === _adapters.RequestStatus.ERROR;
      const testLabel = item.name.replace(/\s+/, '_');
      return {
        'data-test-subj': `inspectorRequestChooser${testLabel}`,
        label: hasFailed ? `${item.name} ${_i18n.i18n.translate('inspector.requests.failedLabel', {
          defaultMessage: ' (failed)'
        })}` : item.name,
        value: item.id
      };
    });
    const requestLabel = _i18n.i18n.translate('inspector.requests.requestLabel', {
      defaultMessage: 'Request'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      "aria-label": requestLabel,
      "data-test-subj": "inspectorRequestChooser",
      fullWidth: true,
      id: "inspectorRequestChooser",
      isClearable: false,
      onChange: this.handleSelected,
      options: options,
      prepend: requestLabel,
      selectedOptions: [{
        label: this.props.selectedRequest.name,
        value: this.props.selectedRequest.id
      }],
      singleSelection: {
        asPlainText: true
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    });
  }
  render() {
    const {
      selectedRequest,
      requests
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }, requests.length && this.renderRequestCombobox()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, selectedRequest.status !== _adapters.RequestStatus.PENDING && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      title: selectedRequest.status === _adapters.RequestStatus.OK ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.requestSucceededTooltipTitle",
        defaultMessage: "Request succeeded",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 19
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.requestFailedTooltipTitle",
        defaultMessage: "Request failed",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 19
        }
      }),
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.requestTooltipDescription",
        defaultMessage: "The total time the request took.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 17
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "inspectorRequestTotalTime",
      tabIndex: 0,
      color: selectedRequest.status === _adapters.RequestStatus.OK ? 'success' : 'danger',
      iconType: selectedRequest.status === _adapters.RequestStatus.OK ? 'check' : 'cross',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.requests.requestTimeLabel",
      defaultMessage: "{requestTime}ms",
      values: {
        requestTime: selectedRequest.time
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 17
      }
    }))), selectedRequest.status === _adapters.RequestStatus.PENDING && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "aria-label": _i18n.i18n.translate('inspector.requests.requestInProgressAriaLabel', {
        defaultMessage: 'Request in progress'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    })));
  }
}
exports.RequestSelector = RequestSelector;
(0, _defineProperty2.default)(RequestSelector, "propTypes", {
  requests: _propTypes.default.array.isRequired,
  selectedRequest: _propTypes.default.object.isRequired,
  onRequestChanged: _propTypes.default.func
});