"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isHtmlTag = exports.isExcludedComponent = exports.isEuiMainComponent = exports.isEui = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isEui = type => type.startsWith('Eui');
exports.isEui = isEui;
const isHtmlTag = type => _constants.HTML_TAGS.includes(type);
exports.isHtmlTag = isHtmlTag;
const isExcludedComponent = type => _constants.EXCLUDED_COMPONENT_TYPES.some(t => type.includes(t));
exports.isExcludedComponent = isExcludedComponent;
const isEuiMainComponent = type => _constants.EUI_COMPONENTS_DOCS_MAP.get(type) !== undefined;
exports.isEuiMainComponent = isEuiMainComponent;